/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.plasma;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.arrow.plasma.ObjectStoreLink;
import org.apache.arrow.plasma.PlasmaClientJNI;
import org.apache.arrow.plasma.exceptions.DuplicateObjectException;
import org.apache.arrow.plasma.exceptions.PlasmaOutOfMemoryException;

@Deprecated
public class PlasmaClient
implements ObjectStoreLink {
    private final long conn;

    protected void finalize() {
        PlasmaClientJNI.disconnect(this.conn);
    }

    public PlasmaClient(String storeSocketName, String managerSocketName, int releaseDelay) {
        this.conn = PlasmaClientJNI.connect(storeSocketName, managerSocketName, releaseDelay);
    }

    @Override
    public void put(byte[] objectId, byte[] value, byte[] metadata) throws DuplicateObjectException, PlasmaOutOfMemoryException {
        ByteBuffer buf = PlasmaClientJNI.create(this.conn, objectId, value.length, metadata);
        buf.put(value);
        PlasmaClientJNI.seal(this.conn, objectId);
        PlasmaClientJNI.release(this.conn, objectId);
    }

    @Override
    public List<byte[]> get(byte[][] objectIds, int timeoutMs, boolean isMetadata) {
        ByteBuffer[][] bufs = PlasmaClientJNI.get(this.conn, objectIds, timeoutMs);
        assert (bufs.length == objectIds.length);
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        for (int i = 0; i < bufs.length; ++i) {
            ByteBuffer buf = bufs[i][isMetadata ? 1 : 0];
            if (buf == null) {
                ret.add(null);
                continue;
            }
            byte[] bb = new byte[buf.remaining()];
            buf.get(bb);
            ret.add(bb);
        }
        return ret;
    }

    @Override
    public byte[] hash(byte[] objectId) {
        return PlasmaClientJNI.hash(this.conn, objectId);
    }

    @Override
    public List<ObjectStoreLink.ObjectStoreData> get(byte[][] objectIds, int timeoutMs) {
        ByteBuffer[][] bufs = PlasmaClientJNI.get(this.conn, objectIds, timeoutMs);
        assert (bufs.length == objectIds.length);
        ArrayList<ObjectStoreLink.ObjectStoreData> ret = new ArrayList<ObjectStoreLink.ObjectStoreData>();
        for (int i = 0; i < bufs.length; ++i) {
            byte[] meta;
            ByteBuffer databuf = bufs[i][0];
            ByteBuffer metabuf = bufs[i][1];
            if (databuf == null) {
                ret.add(new ObjectStoreLink.ObjectStoreData(null, null));
                continue;
            }
            byte[] data = new byte[databuf.remaining()];
            databuf.get(data);
            if (metabuf != null) {
                meta = new byte[metabuf.remaining()];
                metabuf.get(meta);
            } else {
                meta = null;
            }
            ret.add(new ObjectStoreLink.ObjectStoreData(meta, data));
        }
        return ret;
    }

    public ByteBuffer getObjAsByteBuffer(byte[] objectId, int timeoutMs, boolean isMetadata) {
        byte[][] objectIds = new byte[][]{objectId};
        ByteBuffer[][] bufs = PlasmaClientJNI.get(this.conn, objectIds, timeoutMs);
        return bufs[0][isMetadata ? 1 : 0];
    }

    @Override
    public List<byte[]> list() {
        return Arrays.asList(PlasmaClientJNI.list(this.conn));
    }

    @Override
    public long evict(long numBytes) {
        return PlasmaClientJNI.evict(this.conn, numBytes);
    }

    public ByteBuffer create(byte[] objectId, int size, byte[] metadata) throws DuplicateObjectException, PlasmaOutOfMemoryException {
        return PlasmaClientJNI.create(this.conn, objectId, size, metadata);
    }

    public void seal(byte[] objectId) {
        PlasmaClientJNI.seal(this.conn, objectId);
    }

    @Override
    public void release(byte[] objectId) {
        PlasmaClientJNI.release(this.conn, objectId);
    }

    @Override
    public void delete(byte[] objectId) {
        PlasmaClientJNI.delete(this.conn, objectId);
    }

    @Override
    public boolean contains(byte[] objectId) {
        return PlasmaClientJNI.contains(this.conn, objectId);
    }
}

