/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.plasma;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.plasma.ObjectStoreLink;
import org.apache.arrow.plasma.PlasmaClientJNI;

public class PlasmaClient
implements ObjectStoreLink {
    private final long conn;

    protected void finalize() {
        PlasmaClientJNI.disconnect(this.conn);
    }

    public PlasmaClient(String storeSocketName, String managerSocketName, int releaseDelay) {
        this.conn = PlasmaClientJNI.connect(storeSocketName, managerSocketName, releaseDelay);
    }

    @Override
    public void put(byte[] objectId, byte[] value, byte[] metadata) {
        ByteBuffer buf = null;
        try {
            buf = PlasmaClientJNI.create(this.conn, objectId, value.length, metadata);
        }
        catch (Exception e) {
            System.err.println("ObjectId " + objectId + " error at PlasmaClient put");
            e.printStackTrace();
        }
        if (buf == null) {
            return;
        }
        buf.put(value);
        PlasmaClientJNI.seal(this.conn, objectId);
        PlasmaClientJNI.release(this.conn, objectId);
    }

    @Override
    public List<byte[]> get(byte[][] objectIds, int timeoutMs, boolean isMetadata) {
        ByteBuffer[][] bufs = PlasmaClientJNI.get(this.conn, objectIds, timeoutMs);
        assert (bufs.length == objectIds.length);
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        for (int i = 0; i < bufs.length; ++i) {
            ByteBuffer buf = bufs[i][isMetadata ? 1 : 0];
            if (buf == null) {
                ret.add(null);
                continue;
            }
            byte[] bb = new byte[buf.remaining()];
            buf.get(bb);
            ret.add(bb);
        }
        return ret;
    }

    @Override
    public byte[] hash(byte[] objectId) {
        return PlasmaClientJNI.hash(this.conn, objectId);
    }

    @Override
    public List<ObjectStoreLink.ObjectStoreData> get(byte[][] objectIds, int timeoutMs) {
        ByteBuffer[][] bufs = PlasmaClientJNI.get(this.conn, objectIds, timeoutMs);
        assert (bufs.length == objectIds.length);
        ArrayList<ObjectStoreLink.ObjectStoreData> ret = new ArrayList<ObjectStoreLink.ObjectStoreData>();
        for (int i = 0; i < bufs.length; ++i) {
            byte[] meta;
            ByteBuffer databuf = bufs[i][0];
            ByteBuffer metabuf = bufs[i][1];
            if (databuf == null) {
                ret.add(new ObjectStoreLink.ObjectStoreData(null, null));
                continue;
            }
            byte[] data = new byte[databuf.remaining()];
            databuf.get(data);
            if (metabuf != null) {
                meta = new byte[metabuf.remaining()];
                metabuf.get(meta);
            } else {
                meta = null;
            }
            ret.add(new ObjectStoreLink.ObjectStoreData(data, meta));
        }
        return ret;
    }

    @Override
    public long evict(long numBytes) {
        return PlasmaClientJNI.evict(this.conn, numBytes);
    }

    public void seal(byte[] objectId) {
        PlasmaClientJNI.seal(this.conn, objectId);
    }

    @Override
    public void release(byte[] objectId) {
        PlasmaClientJNI.release(this.conn, objectId);
    }

    @Override
    public void delete(byte[] objectId) {
        PlasmaClientJNI.delete(this.conn, objectId);
    }

    @Override
    public boolean contains(byte[] objectId) {
        return PlasmaClientJNI.contains(this.conn, objectId);
    }
}

