/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.vector;

import java.util.concurrent.TimeUnit;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.IntVector;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
public class BaseValueVectorBenchmarks {
    private static final int VECTOR_LENGTH = 1024;
    private static final int ALLOCATOR_CAPACITY = 0x100000;
    private BufferAllocator allocator;
    private IntVector vector;

    @Setup
    public void prepare() {
        this.allocator = new RootAllocator(0x100000L);
        this.vector = new IntVector("vector", this.allocator);
        this.vector.allocateNew(1024);
    }

    @TearDown
    public void tearDown() {
        this.vector.close();
        this.allocator.close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public int testComputeCombinedBufferSize() {
        int totalSize = 0;
        for (int i = 0; i < 1024; ++i) {
            totalSize = (int)((long)totalSize + this.vector.computeCombinedBufferSize(i, 4));
        }
        return totalSize;
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(BaseValueVectorBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }
}

