/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.adapter.jdbc.ArrowVectorIterator;
import org.apache.arrow.adapter.jdbc.JdbcToArrow;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfig;
import org.apache.arrow.adapter.jdbc.JdbcToArrowConfigBuilder;
import org.apache.arrow.adapter.jdbc.consumer.BigIntConsumer;
import org.apache.arrow.adapter.jdbc.consumer.BitConsumer;
import org.apache.arrow.adapter.jdbc.consumer.IntConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.adapter.jdbc.consumer.VarCharConsumer;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class JdbcAdapterBenchmarks {
    private static final int VALUE_COUNT = 3000;
    private static final String CREATE_STATEMENT = "CREATE TABLE test_table (f0 INT, f1 LONG, f2 VARCHAR, f3 BOOLEAN);";
    private static final String INSERT_STATEMENT = "INSERT INTO test_table (f0, f1, f2, f3) VALUES (?, ?, ?, ?);";
    private static final String QUERY = "SELECT f0, f1, f2, f3 FROM test_table;";
    private static final String DROP_STATEMENT = "DROP TABLE test_table;";
    private static final String URL = "jdbc:h2:mem:JdbcAdapterBenchmarks";
    private static final String DRIVER = "org.h2.Driver";

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public int testJdbcToArrow(JdbcState state) throws Exception {
        int valueCount = 0;
        try (ArrowVectorIterator iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)state.resultSet, (JdbcToArrowConfig)state.config);){
            while (iter.hasNext()) {
                VectorSchemaRoot root = iter.next();
                IntVector intVector = (IntVector)root.getFieldVectors().get(0);
                valueCount += intVector.getValueCount();
                root.close();
            }
        }
        return valueCount;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void consumeBenchmark(ConsumeState state) throws Exception {
        state.intConsumer.resetValueVector((ValueVector)state.intVector);
        state.longConsumer.resetValueVector((ValueVector)state.longVector);
        state.varCharConsumer.resetValueVector((ValueVector)state.varCharVector);
        state.bitConsumer.resetValueVector((ValueVector)state.bitVector);
        for (int i = 0; i < 3000; ++i) {
            state.intConsumer.consume(state.resultSet);
            state.longConsumer.consume(state.resultSet);
            state.varCharConsumer.consume(state.resultSet);
            state.bitConsumer.consume(state.resultSet);
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    public void consumeRowsBenchmark(RowConsumeState state) throws Exception {
        for (int i = 0; i < 3000; ++i) {
            ((RowConsumeState)state).iter.compositeConsumer.consume(state.resultSet);
        }
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(JdbcAdapterBenchmarks.class.getSimpleName()).forks(1).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Benchmark)
    public static class JdbcState {
        private Connection conn = null;
        private ResultSet resultSet = null;
        private BufferAllocator allocator;
        private Statement statement;
        private JdbcToArrowConfig config;

        @Setup(value=Level.Trial)
        public void prepareState() throws Exception {
            this.allocator = new RootAllocator(Integer.MAX_VALUE);
            this.config = new JdbcToArrowConfigBuilder().setAllocator(this.allocator).setTargetBatchSize(1024).build();
            Class.forName(JdbcAdapterBenchmarks.DRIVER);
            this.conn = DriverManager.getConnection(JdbcAdapterBenchmarks.URL);
            try (Statement stmt = this.conn.createStatement();){
                stmt.executeUpdate(JdbcAdapterBenchmarks.CREATE_STATEMENT);
            }
            for (int i = 0; i < 3000; ++i) {
                try (PreparedStatement stmt = this.conn.prepareStatement(JdbcAdapterBenchmarks.INSERT_STATEMENT);){
                    stmt.setInt(1, i);
                    stmt.setLong(2, i);
                    stmt.setString(3, "test" + i);
                    stmt.setBoolean(4, i % 2 == 0);
                    stmt.executeUpdate();
                    continue;
                }
            }
        }

        @Setup(value=Level.Invocation)
        public void prepareInvoke() throws Exception {
            this.statement = this.conn.createStatement();
            this.resultSet = this.statement.executeQuery(JdbcAdapterBenchmarks.QUERY);
        }

        @TearDown(value=Level.Invocation)
        public void tearDownInvoke() throws Exception {
            this.resultSet.close();
            this.statement.close();
        }

        @TearDown(value=Level.Trial)
        public void tearDownState() throws Exception {
            try (Statement stmt = this.conn.createStatement();){
                stmt.executeUpdate(JdbcAdapterBenchmarks.DROP_STATEMENT);
            }
            this.allocator.close();
        }
    }

    @State(value=Scope.Benchmark)
    public static class ConsumeState {
        private static final boolean NULLABLE = true;
        private Connection conn = null;
        private ResultSet resultSet = null;
        private BufferAllocator allocator;
        private Statement statement;
        private IntVector intVector;
        private BigIntVector longVector;
        private VarCharVector varCharVector;
        private BitVector bitVector;
        private JdbcConsumer<IntVector> intConsumer;
        private JdbcConsumer<BigIntVector> longConsumer;
        private JdbcConsumer<VarCharVector> varCharConsumer;
        private JdbcConsumer<BitVector> bitConsumer;
        private JdbcToArrowConfig config;

        @Setup(value=Level.Trial)
        public void prepare() throws Exception {
            this.allocator = new RootAllocator(Integer.MAX_VALUE);
            this.config = new JdbcToArrowConfigBuilder().setAllocator(this.allocator).setTargetBatchSize(1024).build();
            Class.forName(JdbcAdapterBenchmarks.DRIVER);
            this.conn = DriverManager.getConnection(JdbcAdapterBenchmarks.URL);
            try (Statement stmt = this.conn.createStatement();){
                stmt.executeUpdate(JdbcAdapterBenchmarks.CREATE_STATEMENT);
            }
            for (int i = 0; i < 3000; ++i) {
                try (PreparedStatement stmt = this.conn.prepareStatement(JdbcAdapterBenchmarks.INSERT_STATEMENT);){
                    stmt.setInt(1, i);
                    stmt.setLong(2, i);
                    stmt.setString(3, "test" + i);
                    stmt.setBoolean(4, i % 2 == 0);
                    stmt.executeUpdate();
                    continue;
                }
            }
            this.statement = this.conn.createStatement();
            this.resultSet = this.statement.executeQuery(JdbcAdapterBenchmarks.QUERY);
            this.resultSet.next();
            this.intVector = new IntVector("", this.allocator);
            this.intVector.allocateNew(3000);
            this.intConsumer = IntConsumer.createConsumer((IntVector)this.intVector, (int)1, (boolean)true);
            this.longVector = new BigIntVector("", this.allocator);
            this.longVector.allocateNew(3000);
            this.longConsumer = BigIntConsumer.createConsumer((BigIntVector)this.longVector, (int)2, (boolean)true);
            this.varCharVector = new VarCharVector("", this.allocator);
            this.varCharVector.allocateNew(3000);
            this.varCharConsumer = VarCharConsumer.createConsumer((VarCharVector)this.varCharVector, (int)3, (boolean)true);
            this.bitVector = new BitVector("", this.allocator);
            this.bitVector.allocateNew(3000);
            this.bitConsumer = BitConsumer.createConsumer((BitVector)this.bitVector, (int)4, (boolean)true);
        }

        @TearDown(value=Level.Trial)
        public void tearDown() throws Exception {
            try (Statement stmt = this.conn.createStatement();){
                stmt.executeUpdate(JdbcAdapterBenchmarks.DROP_STATEMENT);
            }
            this.resultSet.close();
            this.statement.close();
            this.conn.close();
            this.intVector.close();
            this.intConsumer.close();
            this.longVector.close();
            this.longConsumer.close();
            this.varCharVector.close();
            this.varCharConsumer.close();
            this.bitVector.close();
            this.bitConsumer.close();
            this.allocator.close();
        }
    }

    @State(value=Scope.Benchmark)
    public static class RowConsumeState {
        private Connection conn = null;
        private ResultSet resultSet = null;
        private BufferAllocator allocator;
        private Statement statement;
        private JdbcToArrowConfig config;
        private ArrowVectorIterator iter;
        private VectorSchemaRoot root;

        @Setup(value=Level.Trial)
        public void prepareState() throws Exception {
            this.allocator = new RootAllocator(Integer.MAX_VALUE);
            this.config = new JdbcToArrowConfigBuilder().setAllocator(this.allocator).setTargetBatchSize(3000).build();
            Class.forName(JdbcAdapterBenchmarks.DRIVER);
            this.conn = DriverManager.getConnection(JdbcAdapterBenchmarks.URL);
            try (Statement stmt = this.conn.createStatement();){
                stmt.executeUpdate(JdbcAdapterBenchmarks.CREATE_STATEMENT);
            }
            for (int i = 0; i < 3000; ++i) {
                try (PreparedStatement stmt = this.conn.prepareStatement(JdbcAdapterBenchmarks.INSERT_STATEMENT);){
                    stmt.setInt(1, i);
                    stmt.setLong(2, i);
                    stmt.setString(3, "test" + i);
                    stmt.setBoolean(4, i % 2 == 0);
                    stmt.executeUpdate();
                    continue;
                }
            }
        }

        @Setup(value=Level.Invocation)
        public void prepareInvoke() throws Exception {
            this.statement = this.conn.createStatement();
            this.resultSet = this.statement.executeQuery(JdbcAdapterBenchmarks.QUERY);
            this.iter = JdbcToArrow.sqlToArrowVectorIterator((ResultSet)this.resultSet, (JdbcToArrowConfig)this.config);
            this.root = this.iter.next();
            this.iter.compositeConsumer.resetVectorSchemaRoot(this.root);
        }

        @TearDown(value=Level.Invocation)
        public void tearDownInvoke() throws Exception {
            this.resultSet.close();
            this.statement.close();
            this.iter.close();
        }

        @TearDown(value=Level.Trial)
        public void tearDownState() throws Exception {
            try (Statement stmt = this.conn.createStatement();){
                stmt.executeUpdate(JdbcAdapterBenchmarks.DROP_STATEMENT);
            }
            this.allocator.close();
        }
    }
}

