/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.MutableWrappedByteBuf;
import java.util.concurrent.atomic.AtomicLong;

public class LargeBuffer
extends MutableWrappedByteBuf {
    private final AtomicLong hugeBufferSize;
    private final AtomicLong hugeBufferCount;
    private final int initCap;

    public LargeBuffer(ByteBuf buffer, AtomicLong hugeBufferSize, AtomicLong hugeBufferCount) {
        super(buffer);
        this.initCap = buffer.capacity();
        this.hugeBufferCount = hugeBufferCount;
        this.hugeBufferSize = hugeBufferSize;
    }

    @Override
    public ByteBuf copy(int index, int length) {
        return new LargeBuffer(this.buffer.copy(index, length), this.hugeBufferSize, this.hugeBufferCount);
    }

    @Override
    public boolean release() {
        return this.release(1);
    }

    @Override
    public boolean release(int decrement) {
        boolean released = this.unwrap().release(decrement);
        if (released) {
            this.hugeBufferSize.addAndGet(-this.initCap);
            this.hugeBufferCount.decrementAndGet();
        }
        return released;
    }
}

