/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.util.Calendar;
import java.util.Map;
import java.util.function.Function;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;

public final class JdbcToArrowConfig {
    private final Calendar calendar;
    private final BufferAllocator allocator;
    private final boolean includeMetadata;
    private final Map<Integer, JdbcFieldInfo> arraySubTypesByColumnIndex;
    private final Map<String, JdbcFieldInfo> arraySubTypesByColumnName;
    public static final int DEFAULT_TARGET_BATCH_SIZE = 1024;
    public static final int NO_LIMIT_BATCH_SIZE = -1;
    private final int targetBatchSize;
    private final Function<JdbcFieldInfo, ArrowType> jdbcToArrowTypeConverter;

    JdbcToArrowConfig(BufferAllocator allocator, Calendar calendar) {
        this(allocator, calendar, false, null, null, 1024, null);
    }

    JdbcToArrowConfig(BufferAllocator allocator, Calendar calendar, boolean includeMetadata, Map<Integer, JdbcFieldInfo> arraySubTypesByColumnIndex, Map<String, JdbcFieldInfo> arraySubTypesByColumnName, int targetBatchSize, Function<JdbcFieldInfo, ArrowType> jdbcToArrowTypeConverter) {
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory allocator cannot be null");
        this.allocator = allocator;
        this.calendar = calendar;
        this.includeMetadata = includeMetadata;
        this.arraySubTypesByColumnIndex = arraySubTypesByColumnIndex;
        this.arraySubTypesByColumnName = arraySubTypesByColumnName;
        this.targetBatchSize = targetBatchSize;
        this.jdbcToArrowTypeConverter = jdbcToArrowTypeConverter != null ? jdbcToArrowTypeConverter : fieldInfo -> {
            String timezone = calendar != null ? calendar.getTimeZone().getID() : null;
            switch (fieldInfo.getJdbcType()) {
                case -7: 
                case 16: {
                    return new ArrowType.Bool();
                }
                case -6: {
                    return new ArrowType.Int(8, true);
                }
                case 5: {
                    return new ArrowType.Int(16, true);
                }
                case 4: {
                    return new ArrowType.Int(32, true);
                }
                case -5: {
                    return new ArrowType.Int(64, true);
                }
                case 2: 
                case 3: {
                    int precision = fieldInfo.getPrecision();
                    int scale = fieldInfo.getScale();
                    return new ArrowType.Decimal(precision, scale, 128);
                }
                case 6: 
                case 7: {
                    return new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
                }
                case 8: {
                    return new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: 
                case 2005: {
                    return new ArrowType.Utf8();
                }
                case 91: {
                    return new ArrowType.Date(DateUnit.DAY);
                }
                case 92: {
                    return new ArrowType.Time(TimeUnit.MILLISECOND, 32);
                }
                case 93: {
                    return new ArrowType.Timestamp(TimeUnit.MILLISECOND, timezone);
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    return new ArrowType.Binary();
                }
                case 2003: {
                    return new ArrowType.List();
                }
                case 0: {
                    return new ArrowType.Null();
                }
            }
            return null;
        };
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    public boolean shouldIncludeMetadata() {
        return this.includeMetadata;
    }

    public int getTargetBatchSize() {
        return this.targetBatchSize;
    }

    public Function<JdbcFieldInfo, ArrowType> getJdbcToArrowTypeConverter() {
        return this.jdbcToArrowTypeConverter;
    }

    public JdbcFieldInfo getArraySubTypeByColumnIndex(int index) {
        if (this.arraySubTypesByColumnIndex == null) {
            return null;
        }
        return this.arraySubTypesByColumnIndex.get(index);
    }

    public JdbcFieldInfo getArraySubTypeByColumnName(String name) {
        if (this.arraySubTypesByColumnName == null) {
            return null;
        }
        return this.arraySubTypesByColumnName.get(name);
    }
}

