/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.io.IOException;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.complex.ListVector;

public abstract class ArrayConsumer
extends BaseConsumer<ListVector> {
    protected final JdbcConsumer delegate;
    private final ValueVector innerVector;
    protected int innerVectorIndex = 0;

    public static ArrayConsumer createConsumer(ListVector vector, JdbcConsumer delegate, int index, boolean nullable) {
        if (nullable) {
            return new NullableArrayConsumer(vector, delegate, index);
        }
        return new NonNullableArrayConsumer(vector, delegate, index);
    }

    public ArrayConsumer(ListVector vector, JdbcConsumer delegate, int index) {
        super(vector, index);
        this.delegate = delegate;
        this.innerVector = vector.getDataVector();
    }

    @Override
    public void close() throws Exception {
        ((ListVector)this.vector).close();
        this.delegate.close();
    }

    @Override
    public void resetValueVector(ListVector vector) {
        super.resetValueVector(vector);
        FieldVector childVector = vector.getDataVector();
        this.delegate.resetValueVector(childVector);
        this.innerVectorIndex = 0;
    }

    void ensureInnerVectorCapacity(int targetCapacity) {
        while (this.innerVector.getValueCapacity() < targetCapacity) {
            this.innerVector.reAlloc();
        }
    }

    static class NullableArrayConsumer
    extends ArrayConsumer {
        public NullableArrayConsumer(ListVector vector, JdbcConsumer delegate, int index) {
            super(vector, delegate, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException, IOException {
            Array array = resultSet.getArray(this.columnIndexInResultSet);
            if (!resultSet.wasNull()) {
                ((ListVector)this.vector).startNewValue(this.currentIndex);
                int count = 0;
                try (ResultSet rs = array.getResultSet();){
                    while (rs.next()) {
                        this.ensureInnerVectorCapacity(this.innerVectorIndex + count + 1);
                        this.delegate.consume(rs);
                        ++count;
                    }
                }
                ((ListVector)this.vector).endValue(this.currentIndex, count);
                this.innerVectorIndex += count;
            }
            ++this.currentIndex;
        }
    }

    static class NonNullableArrayConsumer
    extends ArrayConsumer {
        public NonNullableArrayConsumer(ListVector vector, JdbcConsumer delegate, int index) {
            super(vector, delegate, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException, IOException {
            Array array = resultSet.getArray(this.columnIndexInResultSet);
            ((ListVector)this.vector).startNewValue(this.currentIndex);
            int count = 0;
            try (ResultSet rs = array.getResultSet();){
                while (rs.next()) {
                    this.ensureInnerVectorCapacity(this.innerVectorIndex + count + 1);
                    this.delegate.consume(rs);
                    ++count;
                }
            }
            ((ListVector)this.vector).endValue(this.currentIndex, count);
            this.innerVectorIndex += count;
            ++this.currentIndex;
        }
    }
}

