/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.DateDayVector;

public class DateConsumer {
    public static JdbcConsumer<DateDayVector> createConsumer(DateDayVector vector, int index, boolean nullable, Calendar calendar) {
        if (nullable) {
            return new NullableDateConsumer(vector, index, calendar);
        }
        return new NonNullableDateConsumer(vector, index, calendar);
    }

    static class NullableDateConsumer
    extends BaseConsumer<DateDayVector> {
        protected final Calendar calendar;

        public NullableDateConsumer(DateDayVector vector, int index) {
            this(vector, index, null);
        }

        public NullableDateConsumer(DateDayVector vector, int index, Calendar calendar) {
            super(vector, index);
            this.calendar = calendar;
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            Date date;
            Date date2 = date = this.calendar == null ? resultSet.getDate(this.columnIndexInResultSet) : resultSet.getDate(this.columnIndexInResultSet, this.calendar);
            if (!resultSet.wasNull()) {
                ((DateDayVector)this.vector).set(this.currentIndex, Math.toIntExact(TimeUnit.MILLISECONDS.toDays(date.getTime())));
            }
            ++this.currentIndex;
        }
    }

    static class NonNullableDateConsumer
    extends BaseConsumer<DateDayVector> {
        protected final Calendar calendar;

        public NonNullableDateConsumer(DateDayVector vector, int index) {
            this(vector, index, null);
        }

        public NonNullableDateConsumer(DateDayVector vector, int index, Calendar calendar) {
            super(vector, index);
            this.calendar = calendar;
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            Date date = this.calendar == null ? resultSet.getDate(this.columnIndexInResultSet) : resultSet.getDate(this.columnIndexInResultSet, this.calendar);
            ((DateDayVector)this.vector).set(this.currentIndex, Math.toIntExact(TimeUnit.MILLISECONDS.toDays(date.getTime())));
            ++this.currentIndex;
        }
    }
}

