/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.arrow.adapter.jdbc.binder.ColumnBinder;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.VectorSchemaRoot;

public class JdbcParameterBinder {
    private final PreparedStatement statement;
    private final VectorSchemaRoot root;
    private final ColumnBinder[] binders;
    private final int[] parameterIndices;
    private int nextRowIndex;

    private JdbcParameterBinder(PreparedStatement statement, VectorSchemaRoot root, ColumnBinder[] binders, int[] parameterIndices) {
        Preconditions.checkArgument((binders.length == parameterIndices.length ? 1 : 0) != 0, (String)"Number of column binders (%s) must equal number of parameter indices (%s)", (int)binders.length, (int)parameterIndices.length);
        this.statement = statement;
        this.root = root;
        this.binders = binders;
        this.parameterIndices = parameterIndices;
        this.nextRowIndex = 0;
    }

    public static Builder builder(PreparedStatement statement, VectorSchemaRoot root) {
        return new Builder(statement, root);
    }

    public void reset() {
        this.nextRowIndex = 0;
    }

    public boolean next() throws SQLException {
        if (this.nextRowIndex >= this.root.getRowCount()) {
            return false;
        }
        for (int i = 0; i < this.parameterIndices.length; ++i) {
            int parameterIndex = this.parameterIndices[i];
            this.binders[i].bind(this.statement, parameterIndex, this.nextRowIndex);
        }
        ++this.nextRowIndex;
        return true;
    }

    public static class Builder {
        private final PreparedStatement statement;
        private final VectorSchemaRoot root;
        private final Map<Integer, ColumnBinder> bindings;

        Builder(PreparedStatement statement, VectorSchemaRoot root) {
            this.statement = statement;
            this.root = root;
            this.bindings = new HashMap<Integer, ColumnBinder>();
        }

        public Builder bindAll() {
            for (int i = 0; i < this.root.getFieldVectors().size(); ++i) {
                this.bind(i + 1, i);
            }
            return this;
        }

        public Builder bind(int parameterIndex, int columnIndex) {
            return this.bind(parameterIndex, ColumnBinder.forVector(this.root.getVector(columnIndex)));
        }

        public Builder bind(int parameterIndex, ColumnBinder binder) {
            Preconditions.checkArgument((parameterIndex > 0 ? 1 : 0) != 0, (String)"parameterIndex %d must be positive", (int)parameterIndex);
            this.bindings.put(parameterIndex, binder);
            return this;
        }

        public JdbcParameterBinder build() {
            ColumnBinder[] binders = new ColumnBinder[this.bindings.size()];
            int[] parameterIndices = new int[this.bindings.size()];
            int index = 0;
            for (Map.Entry<Integer, ColumnBinder> entry : this.bindings.entrySet()) {
                binders[index] = entry.getValue();
                parameterIndices[index] = entry.getKey();
                ++index;
            }
            return new JdbcParameterBinder(this.statement, this.root, binders, parameterIndices);
        }
    }
}

