/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.TimeStampMilliTZVector;

public class TimestampTZConsumer {
    public static JdbcConsumer<TimeStampMilliTZVector> createConsumer(TimeStampMilliTZVector vector, int index, boolean nullable, Calendar calendar) {
        Preconditions.checkArgument((calendar != null ? 1 : 0) != 0, (Object)"Calendar cannot be null");
        if (nullable) {
            return new NullableTimestampTZConsumer(vector, index, calendar);
        }
        return new NonNullableTimestampConsumer(vector, index, calendar);
    }

    static class NonNullableTimestampConsumer
    extends BaseConsumer<TimeStampMilliTZVector> {
        protected final Calendar calendar;

        public NonNullableTimestampConsumer(TimeStampMilliTZVector vector, int index, Calendar calendar) {
            super(vector, index);
            this.calendar = calendar;
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            Timestamp timestamp = resultSet.getTimestamp(this.columnIndexInResultSet, this.calendar);
            ((TimeStampMilliTZVector)this.vector).set(this.currentIndex, timestamp.getTime());
            ++this.currentIndex;
        }
    }

    static class NullableTimestampTZConsumer
    extends BaseConsumer<TimeStampMilliTZVector> {
        protected final Calendar calendar;

        public NullableTimestampTZConsumer(TimeStampMilliTZVector vector, int index, Calendar calendar) {
            super(vector, index);
            this.calendar = calendar;
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            Timestamp timestamp = resultSet.getTimestamp(this.columnIndexInResultSet, this.calendar);
            if (!resultSet.wasNull()) {
                ((TimeStampMilliTZVector)this.vector).set(this.currentIndex, timestamp.getTime());
            }
            ++this.currentIndex;
        }
    }
}

