/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.binder;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;
import org.apache.arrow.adapter.jdbc.binder.BaseColumnBinder;
import org.apache.arrow.vector.DateDayVector;

public class DateDayBinder
extends BaseColumnBinder<DateDayVector> {
    private static final long MILLIS_PER_DAY = 86400000L;
    private final Calendar calendar;

    public DateDayBinder(DateDayVector vector) {
        this(vector, null, 91);
    }

    public DateDayBinder(DateDayVector vector, Calendar calendar) {
        this(vector, calendar, 91);
    }

    public DateDayBinder(DateDayVector vector, Calendar calendar, int jdbcType) {
        super(vector, jdbcType);
        this.calendar = calendar;
    }

    @Override
    public void bind(PreparedStatement statement, int parameterIndex, int rowIndex) throws SQLException {
        long index = (long)rowIndex * 4L;
        Date value = new Date((long)((DateDayVector)this.vector).getDataBuffer().getInt(index) * 86400000L);
        if (this.calendar == null) {
            statement.setDate(parameterIndex, value);
        } else {
            statement.setDate(parameterIndex, value, this.calendar);
        }
    }
}

