/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.DateDayVector;

public class DateConsumer {
    public static final int MAX_DAY;

    public static JdbcConsumer<DateDayVector> createConsumer(DateDayVector vector, int index, boolean nullable, Calendar calendar) {
        if (nullable) {
            return new NullableDateConsumer(vector, index, calendar);
        }
        return new NonNullableDateConsumer(vector, index, calendar);
    }

    static {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = dateFormat.parse("9999-12-31");
            MAX_DAY = (int)TimeUnit.MILLISECONDS.toDays(date.getTime());
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse max day", e);
        }
    }

    static class NonNullableDateConsumer
    extends BaseConsumer<DateDayVector> {
        protected final Calendar calendar;

        public NonNullableDateConsumer(DateDayVector vector, int index) {
            this(vector, index, null);
        }

        public NonNullableDateConsumer(DateDayVector vector, int index, Calendar calendar) {
            super(vector, index);
            this.calendar = calendar;
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            java.sql.Date date = this.calendar == null ? resultSet.getDate(this.columnIndexInResultSet) : resultSet.getDate(this.columnIndexInResultSet, this.calendar);
            int day = (int)TimeUnit.MILLISECONDS.toDays(date.getTime());
            if (day < 0 || day > MAX_DAY) {
                throw new IllegalArgumentException("Day overflow: " + day);
            }
            ((DateDayVector)this.vector).setSafe(this.currentIndex, day);
            ++this.currentIndex;
        }
    }

    static class NullableDateConsumer
    extends BaseConsumer<DateDayVector> {
        protected final Calendar calendar;

        public NullableDateConsumer(DateDayVector vector, int index) {
            this(vector, index, null);
        }

        public NullableDateConsumer(DateDayVector vector, int index, Calendar calendar) {
            super(vector, index);
            this.calendar = calendar;
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            java.sql.Date date;
            java.sql.Date date2 = date = this.calendar == null ? resultSet.getDate(this.columnIndexInResultSet) : resultSet.getDate(this.columnIndexInResultSet, this.calendar);
            if (!resultSet.wasNull()) {
                int day = (int)TimeUnit.MILLISECONDS.toDays(date.getTime());
                if (day < 0 || day > MAX_DAY) {
                    throw new IllegalArgumentException("Day overflow: " + day);
                }
                ((DateDayVector)this.vector).setSafe(this.currentIndex, day);
            }
            ++this.currentIndex;
        }
    }
}

