/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.TinyIntVector;

public abstract class TinyIntConsumer {
    public static JdbcConsumer<TinyIntVector> createConsumer(TinyIntVector vector, int index, boolean nullable) {
        if (nullable) {
            return new NullableTinyIntConsumer(vector, index);
        }
        return new NonNullableTinyIntConsumer(vector, index);
    }

    static class NonNullableTinyIntConsumer
    extends BaseConsumer<TinyIntVector> {
        public NonNullableTinyIntConsumer(TinyIntVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            byte value = resultSet.getByte(this.columnIndexInResultSet);
            ((TinyIntVector)this.vector).setSafe(this.currentIndex, value);
            ++this.currentIndex;
        }
    }

    static class NullableTinyIntConsumer
    extends BaseConsumer<TinyIntVector> {
        public NullableTinyIntConsumer(TinyIntVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            byte value = resultSet.getByte(this.columnIndexInResultSet);
            if (!resultSet.wasNull()) {
                ((TinyIntVector)this.vector).setSafe(this.currentIndex, value);
            }
            ++this.currentIndex;
        }
    }
}

