/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.TimeMilliVector;

public abstract class TimeConsumer {
    public static JdbcConsumer<TimeMilliVector> createConsumer(TimeMilliVector vector, int index, boolean nullable, Calendar calendar) {
        if (nullable) {
            return new NullableTimeConsumer(vector, index, calendar);
        }
        return new NonNullableTimeConsumer(vector, index, calendar);
    }

    static class NonNullableTimeConsumer
    extends BaseConsumer<TimeMilliVector> {
        protected final Calendar calendar;

        public NonNullableTimeConsumer(TimeMilliVector vector, int index) {
            this(vector, index, null);
        }

        public NonNullableTimeConsumer(TimeMilliVector vector, int index, Calendar calendar) {
            super(vector, index);
            this.calendar = calendar;
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            Time time = this.calendar == null ? resultSet.getTime(this.columnIndexInResultSet) : resultSet.getTime(this.columnIndexInResultSet, this.calendar);
            ((TimeMilliVector)this.vector).setSafe(this.currentIndex, (int)time.getTime());
            ++this.currentIndex;
        }
    }

    static class NullableTimeConsumer
    extends BaseConsumer<TimeMilliVector> {
        protected final Calendar calendar;

        public NullableTimeConsumer(TimeMilliVector vector, int index) {
            this(vector, index, null);
        }

        public NullableTimeConsumer(TimeMilliVector vector, int index, Calendar calendar) {
            super(vector, index);
            this.calendar = calendar;
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            Time time;
            Time time2 = time = this.calendar == null ? resultSet.getTime(this.columnIndexInResultSet) : resultSet.getTime(this.columnIndexInResultSet, this.calendar);
            if (!resultSet.wasNull()) {
                ((TimeMilliVector)this.vector).setSafe(this.currentIndex, (int)time.getTime());
            }
            ++this.currentIndex;
        }
    }
}

