/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.IntVector;

public class IntConsumer {
    public static JdbcConsumer<IntVector> createConsumer(IntVector vector, int index, boolean nullable) {
        if (nullable) {
            return new NullableIntConsumer(vector, index);
        }
        return new NonNullableIntConsumer(vector, index);
    }

    static class NonNullableIntConsumer
    extends BaseConsumer<IntVector> {
        public NonNullableIntConsumer(IntVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            int value = resultSet.getInt(this.columnIndexInResultSet);
            ((IntVector)this.vector).setSafe(this.currentIndex, value);
            ++this.currentIndex;
        }
    }

    static class NullableIntConsumer
    extends BaseConsumer<IntVector> {
        public NullableIntConsumer(IntVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            int value = resultSet.getInt(this.columnIndexInResultSet);
            if (!resultSet.wasNull()) {
                ((IntVector)this.vector).setSafe(this.currentIndex, value);
            }
            ++this.currentIndex;
        }
    }
}

