/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.Float8Vector;

public class DoubleConsumer {
    public static JdbcConsumer<Float8Vector> createConsumer(Float8Vector vector, int index, boolean nullable) {
        if (nullable) {
            return new NullableDoubleConsumer(vector, index);
        }
        return new NonNullableDoubleConsumer(vector, index);
    }

    static class NonNullableDoubleConsumer
    extends BaseConsumer<Float8Vector> {
        public NonNullableDoubleConsumer(Float8Vector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            double value = resultSet.getDouble(this.columnIndexInResultSet);
            ((Float8Vector)this.vector).setSafe(this.currentIndex, value);
            ++this.currentIndex;
        }
    }

    static class NullableDoubleConsumer
    extends BaseConsumer<Float8Vector> {
        public NullableDoubleConsumer(Float8Vector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            double value = resultSet.getDouble(this.columnIndexInResultSet);
            if (!resultSet.wasNull()) {
                ((Float8Vector)this.vector).setSafe(this.currentIndex, value);
            }
            ++this.currentIndex;
        }
    }
}

