/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import io.netty.buffer.ArrowBuf;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.VarBinaryVector;

public abstract class BinaryConsumer
extends BaseConsumer<VarBinaryVector> {
    private static final int BUFFER_SIZE = 1024;

    public static BinaryConsumer createConsumer(VarBinaryVector vector, int index, boolean nullable) {
        if (nullable) {
            return new NullableBinaryConsumer(vector, index);
        }
        return new NonNullableBinaryConsumer(vector, index);
    }

    public BinaryConsumer(VarBinaryVector vector, int index) {
        super(vector, index);
        if (vector != null) {
            vector.allocateNewSafe();
        }
    }

    public void consume(InputStream is) throws IOException {
        if (is != null) {
            int read;
            byte[] bytes = new byte[1024];
            int totalBytes = 0;
            ArrowBuf dataBuffer = ((VarBinaryVector)this.vector).getDataBuffer();
            ArrowBuf offsetBuffer = ((VarBinaryVector)this.vector).getOffsetBuffer();
            int startIndex = offsetBuffer.getInt((long)(this.currentIndex * 4));
            while ((read = is.read(bytes)) != -1) {
                while (dataBuffer.writerIndex() + (long)read > dataBuffer.capacity()) {
                    ((VarBinaryVector)this.vector).reallocDataBuffer();
                }
                PlatformDependent.copyMemory((byte[])bytes, (int)0, (long)(dataBuffer.memoryAddress() + (long)startIndex + (long)totalBytes), (long)read);
                totalBytes += read;
            }
            offsetBuffer.setInt((long)((this.currentIndex + 1) * 4), startIndex + totalBytes);
            BitVectorHelper.setBit((ArrowBuf)((VarBinaryVector)this.vector).getValidityBuffer(), (int)this.currentIndex);
            ((VarBinaryVector)this.vector).setLastSet(this.currentIndex);
        }
    }

    public void moveWriterPosition() {
        ++this.currentIndex;
    }

    @Override
    public void resetValueVector(VarBinaryVector vector) {
        this.vector = vector;
        ((VarBinaryVector)this.vector).allocateNewSafe();
        this.currentIndex = 0;
    }

    static class NonNullableBinaryConsumer
    extends BinaryConsumer {
        public NonNullableBinaryConsumer(VarBinaryVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException, IOException {
            InputStream is = resultSet.getBinaryStream(this.columnIndexInResultSet);
            this.consume(is);
            ++this.currentIndex;
        }
    }

    static class NullableBinaryConsumer
    extends BinaryConsumer {
        public NullableBinaryConsumer(VarBinaryVector vector, int index) {
            super(vector, index);
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException, IOException {
            InputStream is = resultSet.getBinaryStream(this.columnIndexInResultSet);
            if (!resultSet.wasNull()) {
                this.consume(is);
            }
            ++this.currentIndex;
        }
    }
}

