/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import java.util.Calendar;
import java.util.Map;
import org.apache.arrow.adapter.jdbc.JdbcFieldInfo;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.util.Preconditions;

public final class JdbcToArrowConfig {
    private Calendar calendar;
    private BaseAllocator allocator;
    private boolean includeMetadata;
    private Map<Integer, JdbcFieldInfo> arraySubTypesByColumnIndex;
    private Map<String, JdbcFieldInfo> arraySubTypesByColumnName;
    public static final int DEFAULT_TARGET_BATCH_SIZE = 1024;
    public static final int NO_LIMIT_BATCH_SIZE = -1;
    private int targetBatchSize = 1024;

    JdbcToArrowConfig(BaseAllocator allocator, Calendar calendar) {
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory allocator cannot be null");
        this.allocator = allocator;
        this.calendar = calendar;
        this.includeMetadata = false;
        this.arraySubTypesByColumnIndex = null;
        this.arraySubTypesByColumnName = null;
    }

    JdbcToArrowConfig(BaseAllocator allocator, Calendar calendar, boolean includeMetadata, Map<Integer, JdbcFieldInfo> arraySubTypesByColumnIndex, Map<String, JdbcFieldInfo> arraySubTypesByColumnName, int targetBatchSize) {
        this(allocator, calendar);
        this.includeMetadata = includeMetadata;
        this.arraySubTypesByColumnIndex = arraySubTypesByColumnIndex;
        this.arraySubTypesByColumnName = arraySubTypesByColumnName;
        this.targetBatchSize = targetBatchSize;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public BaseAllocator getAllocator() {
        return this.allocator;
    }

    public boolean shouldIncludeMetadata() {
        return this.includeMetadata;
    }

    public int getTargetBatchSize() {
        return this.targetBatchSize;
    }

    public JdbcFieldInfo getArraySubTypeByColumnIndex(int index) {
        if (this.arraySubTypesByColumnIndex == null) {
            return null;
        }
        return this.arraySubTypesByColumnIndex.get(index);
    }

    public JdbcFieldInfo getArraySubTypeByColumnName(String name) {
        if (this.arraySubTypesByColumnName == null) {
            return null;
        }
        return this.arraySubTypesByColumnName.get(name);
    }
}

