/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import org.apache.arrow.adapter.jdbc.consumer.BaseConsumer;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.DateMilliVector;

public class DateConsumer {
    public static JdbcConsumer<DateMilliVector> createConsumer(DateMilliVector vector, int index, boolean nullable, Calendar calendar) {
        if (nullable) {
            return new NullableDateConsumer(vector, index, calendar);
        }
        return new NonNullableDateConsumer(vector, index, calendar);
    }

    static class NonNullableDateConsumer
    extends BaseConsumer<DateMilliVector> {
        protected final Calendar calendar;

        public NonNullableDateConsumer(DateMilliVector vector, int index) {
            this(vector, index, null);
        }

        public NonNullableDateConsumer(DateMilliVector vector, int index, Calendar calendar) {
            super(vector, index);
            this.calendar = calendar;
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            Date date = this.calendar == null ? resultSet.getDate(this.columnIndexInResultSet) : resultSet.getDate(this.columnIndexInResultSet, this.calendar);
            ((DateMilliVector)this.vector).setSafe(this.currentIndex, date.getTime());
            ++this.currentIndex;
        }
    }

    static class NullableDateConsumer
    extends BaseConsumer<DateMilliVector> {
        protected final Calendar calendar;

        public NullableDateConsumer(DateMilliVector vector, int index) {
            this(vector, index, null);
        }

        public NullableDateConsumer(DateMilliVector vector, int index, Calendar calendar) {
            super(vector, index);
            this.calendar = calendar;
        }

        @Override
        public void consume(ResultSet resultSet) throws SQLException {
            Date date;
            Date date2 = date = this.calendar == null ? resultSet.getDate(this.columnIndexInResultSet) : resultSet.getDate(this.columnIndexInResultSet, this.calendar);
            if (!resultSet.wasNull()) {
                ((DateMilliVector)this.vector).setSafe(this.currentIndex, date.getTime());
            }
            ++this.currentIndex;
        }
    }
}

