/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.TimeMilliVector;

public class TimeConsumer
implements JdbcConsumer<TimeMilliVector> {
    private TimeMilliVector vector;
    private final int columnIndexInResultSet;
    private final Calendar calendar;
    private int currentIndex;

    public TimeConsumer(TimeMilliVector vector, int index) {
        this(vector, index, null);
    }

    public TimeConsumer(TimeMilliVector vector, int index, Calendar calendar) {
        this.vector = vector;
        this.columnIndexInResultSet = index;
        this.calendar = calendar;
    }

    @Override
    public void consume(ResultSet resultSet) throws SQLException {
        Time time;
        Time time2 = time = this.calendar == null ? resultSet.getTime(this.columnIndexInResultSet) : resultSet.getTime(this.columnIndexInResultSet, this.calendar);
        if (!resultSet.wasNull()) {
            this.vector.setSafe(this.currentIndex, (int)time.getTime());
        }
        ++this.currentIndex;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void resetValueVector(TimeMilliVector vector) {
        this.vector = vector;
        this.currentIndex = 0;
    }
}

