/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.ValueVector;

public class CompositeJdbcConsumer
implements JdbcConsumer {
    private final JdbcConsumer[] consumers;

    public CompositeJdbcConsumer(JdbcConsumer[] consumers) {
        this.consumers = consumers;
    }

    @Override
    public void consume(ResultSet rs) throws SQLException, IOException {
        for (JdbcConsumer consumer : this.consumers) {
            consumer.consume(rs);
        }
    }

    @Override
    public void close() {
        try {
            AutoCloseables.close((AutoCloseable[])this.consumers);
        }
        catch (Exception e) {
            throw new RuntimeException("Error occured while releasing resources.", e);
        }
    }

    public void resetValueVector(ValueVector vector) {
    }
}

