/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.BitVector;

public class BitConsumer
implements JdbcConsumer<BitVector> {
    private BitVector vector;
    private final int columnIndexInResultSet;
    private int currentIndex;

    public BitConsumer(BitVector vector, int index) {
        this.vector = vector;
        this.columnIndexInResultSet = index;
    }

    @Override
    public void consume(ResultSet resultSet) throws SQLException {
        boolean value = resultSet.getBoolean(this.columnIndexInResultSet);
        if (!resultSet.wasNull()) {
            this.vector.setSafe(this.currentIndex, value ? 1 : 0);
        }
        ++this.currentIndex;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void resetValueVector(BitVector vector) {
        this.vector = vector;
        this.currentIndex = 0;
    }
}

