/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import java.io.IOException;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.complex.ListVector;

public class ArrayConsumer
implements JdbcConsumer<ListVector> {
    private final JdbcConsumer delegate;
    private final int columnIndexInResultSet;
    private ListVector vector;
    private int currentIndex;

    public ArrayConsumer(ListVector vector, JdbcConsumer delegate, int index) {
        this.columnIndexInResultSet = index;
        this.delegate = delegate;
        this.vector = vector;
    }

    @Override
    public void consume(ResultSet resultSet) throws SQLException, IOException {
        Array array = resultSet.getArray(this.columnIndexInResultSet);
        if (!resultSet.wasNull()) {
            this.vector.startNewValue(this.currentIndex);
            int count = 0;
            try (ResultSet rs = array.getResultSet();){
                while (rs.next()) {
                    this.delegate.consume(rs);
                    ++count;
                }
            }
            this.vector.endValue(this.currentIndex, count);
        }
        ++this.currentIndex;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
        this.delegate.close();
    }

    @Override
    public void resetValueVector(ListVector vector) {
        this.vector = vector;
        this.currentIndex = 0;
    }
}

