/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc.consumer;

import io.netty.buffer.ArrowBuf;
import io.netty.util.internal.PlatformDependent;
import java.nio.charset.StandardCharsets;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.arrow.adapter.jdbc.consumer.JdbcConsumer;
import org.apache.arrow.vector.BitVectorHelper;
import org.apache.arrow.vector.VarCharVector;

public class ClobConsumer
implements JdbcConsumer<VarCharVector> {
    private static final int BUFFER_SIZE = 256;
    private VarCharVector vector;
    private final int columnIndexInResultSet;
    private int currentIndex;

    public ClobConsumer(VarCharVector vector, int index) {
        if (vector != null) {
            vector.allocateNewSafe();
        }
        this.vector = vector;
        this.columnIndexInResultSet = index;
    }

    @Override
    public void consume(ResultSet resultSet) throws SQLException {
        Clob clob = resultSet.getClob(this.columnIndexInResultSet);
        if (!resultSet.wasNull() && clob != null) {
            long length = clob.length();
            int read = 1;
            int readSize = length < 256L ? (int)length : 256;
            int totalBytes = 0;
            ArrowBuf dataBuffer = this.vector.getDataBuffer();
            ArrowBuf offsetBuffer = this.vector.getOffsetBuffer();
            int startIndex = offsetBuffer.getInt(this.currentIndex * 4);
            while ((long)read <= length) {
                String str = clob.getSubString(read, readSize);
                byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
                while (dataBuffer.writerIndex() + bytes.length > dataBuffer.capacity()) {
                    this.vector.reallocDataBuffer();
                }
                PlatformDependent.copyMemory((byte[])bytes, (int)0, (long)(dataBuffer.memoryAddress() + (long)startIndex + (long)totalBytes), (long)bytes.length);
                totalBytes += bytes.length;
                read += readSize;
            }
            offsetBuffer.setInt((this.currentIndex + 1) * 4, startIndex + totalBytes);
            BitVectorHelper.setValidityBitToOne((ArrowBuf)this.vector.getValidityBuffer(), (int)this.currentIndex);
            this.vector.setLastSet(this.currentIndex);
        }
        ++this.currentIndex;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void resetValueVector(VarCharVector vector) {
        this.vector = vector;
        this.vector.allocateNewSafe();
        this.currentIndex = 0;
    }
}

