/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import com.google.common.base.Preconditions;
import io.netty.buffer.ArrowBuf;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.arrow.vector.BaseFixedWidthVector;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeStampVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.holders.NullableBigIntHolder;
import org.apache.arrow.vector.holders.NullableBitHolder;
import org.apache.arrow.vector.holders.NullableDateMilliHolder;
import org.apache.arrow.vector.holders.NullableDecimalHolder;
import org.apache.arrow.vector.holders.NullableFloat4Holder;
import org.apache.arrow.vector.holders.NullableFloat8Holder;
import org.apache.arrow.vector.holders.NullableIntHolder;
import org.apache.arrow.vector.holders.NullableSmallIntHolder;
import org.apache.arrow.vector.holders.NullableTimeMilliHolder;
import org.apache.arrow.vector.holders.NullableTinyIntHolder;
import org.apache.arrow.vector.holders.NullableVarCharHolder;
import org.apache.arrow.vector.holders.VarBinaryHolder;
import org.apache.arrow.vector.holders.VarCharHolder;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.DecimalUtility;

public class JdbcToArrowUtils {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private static final int DEFAULT_STREAM_BUFFER_SIZE = 1024;
    private static final int DEFAULT_CLOB_SUBSTRING_READ_SIZE = 256;

    public static Schema jdbcToArrowSchema(ResultSetMetaData rsmd, Calendar calendar) throws SQLException {
        Preconditions.checkNotNull((Object)rsmd, (Object)"JDBC ResultSetMetaData object can't be null");
        Preconditions.checkNotNull((Object)calendar, (Object)"Calendar object can't be null");
        ArrayList<Field> fields = new ArrayList<Field>();
        int columnCount = rsmd.getColumnCount();
        block18: for (int i = 1; i <= columnCount; ++i) {
            String columnName = rsmd.getColumnName(i);
            switch (rsmd.getColumnType(i)) {
                case -7: 
                case 16: {
                    fields.add(new Field(columnName, FieldType.nullable((ArrowType)new ArrowType.Bool()), null));
                    continue block18;
                }
                case -6: {
                    fields.add(new Field(columnName, FieldType.nullable((ArrowType)new ArrowType.Int(8, true)), null));
                    continue block18;
                }
                case 5: {
                    fields.add(new Field(columnName, FieldType.nullable((ArrowType)new ArrowType.Int(16, true)), null));
                    continue block18;
                }
                case 4: {
                    fields.add(new Field(columnName, FieldType.nullable((ArrowType)new ArrowType.Int(32, true)), null));
                    continue block18;
                }
                case -5: {
                    fields.add(new Field(columnName, FieldType.nullable((ArrowType)new ArrowType.Int(64, true)), null));
                    continue block18;
                }
                case 2: 
                case 3: {
                    int precision = rsmd.getPrecision(i);
                    int scale = rsmd.getScale(i);
                    fields.add(new Field(columnName, FieldType.nullable((ArrowType)new ArrowType.Decimal(precision, scale)), null));
                    continue block18;
                }
                case 6: 
                case 7: {
                    fields.add(new Field(columnName, FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE)), null));
                    continue block18;
                }
                case 8: {
                    fields.add(new Field(columnName, FieldType.nullable((ArrowType)new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE)), null));
                    continue block18;
                }
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    fields.add(new Field(columnName, FieldType.nullable((ArrowType)new ArrowType.Utf8()), null));
                    continue block18;
                }
                case 91: {
                    fields.add(new Field(columnName, FieldType.nullable((ArrowType)new ArrowType.Date(DateUnit.MILLISECOND)), null));
                    continue block18;
                }
                case 92: {
                    fields.add(new Field(columnName, FieldType.nullable((ArrowType)new ArrowType.Time(TimeUnit.MILLISECOND, 32)), null));
                    continue block18;
                }
                case 93: {
                    fields.add(new Field(columnName, FieldType.nullable((ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, calendar.getTimeZone().getID())), null));
                    continue block18;
                }
                case -4: 
                case -3: 
                case -2: {
                    fields.add(new Field(columnName, FieldType.nullable((ArrowType)new ArrowType.Binary()), null));
                    continue block18;
                }
                case 2003: {
                    continue block18;
                }
                case 2005: {
                    fields.add(new Field(columnName, FieldType.nullable((ArrowType)new ArrowType.Utf8()), null));
                    continue block18;
                }
                case 2004: {
                    fields.add(new Field(columnName, FieldType.nullable((ArrowType)new ArrowType.Binary()), null));
                    continue block18;
                }
            }
        }
        return new Schema(fields, null);
    }

    private static void allocateVectors(VectorSchemaRoot root, int size) {
        List vectors = root.getFieldVectors();
        for (FieldVector fieldVector : vectors) {
            if (fieldVector instanceof BaseFixedWidthVector) {
                ((BaseFixedWidthVector)fieldVector).allocateNew(size);
            } else {
                fieldVector.allocateNew();
            }
            fieldVector.setInitialCapacity(size);
        }
    }

    public static void jdbcToArrowVectors(ResultSet rs, VectorSchemaRoot root, Calendar calendar) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)rs, (Object)"JDBC ResultSet object can't be null");
        Preconditions.checkNotNull((Object)root, (Object)"JDBC ResultSet object can't be null");
        Preconditions.checkNotNull((Object)calendar, (Object)"Calendar object can't be null");
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        JdbcToArrowUtils.allocateVectors(root, 256);
        int rowCount = 0;
        while (rs.next()) {
            block19: for (int i = 1; i <= columnCount; ++i) {
                String columnName = rsmd.getColumnName(i);
                switch (rsmd.getColumnType(i)) {
                    case -7: 
                    case 16: {
                        JdbcToArrowUtils.updateVector((BitVector)root.getVector(columnName), rs.getBoolean(i), !rs.wasNull(), rowCount);
                        continue block19;
                    }
                    case -6: {
                        JdbcToArrowUtils.updateVector((TinyIntVector)root.getVector(columnName), rs.getInt(i), !rs.wasNull(), rowCount);
                        continue block19;
                    }
                    case 5: {
                        JdbcToArrowUtils.updateVector((SmallIntVector)root.getVector(columnName), rs.getInt(i), !rs.wasNull(), rowCount);
                        continue block19;
                    }
                    case 4: {
                        JdbcToArrowUtils.updateVector((IntVector)root.getVector(columnName), rs.getInt(i), !rs.wasNull(), rowCount);
                        continue block19;
                    }
                    case -5: {
                        JdbcToArrowUtils.updateVector((BigIntVector)root.getVector(columnName), rs.getLong(i), !rs.wasNull(), rowCount);
                        continue block19;
                    }
                    case 2: 
                    case 3: {
                        JdbcToArrowUtils.updateVector((DecimalVector)root.getVector(columnName), rs.getBigDecimal(i), !rs.wasNull(), rowCount);
                        continue block19;
                    }
                    case 6: 
                    case 7: {
                        JdbcToArrowUtils.updateVector((Float4Vector)root.getVector(columnName), rs.getFloat(i), !rs.wasNull(), rowCount);
                        continue block19;
                    }
                    case 8: {
                        JdbcToArrowUtils.updateVector((Float8Vector)root.getVector(columnName), rs.getDouble(i), !rs.wasNull(), rowCount);
                        continue block19;
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case -1: 
                    case 1: 
                    case 12: {
                        JdbcToArrowUtils.updateVector((VarCharVector)root.getVector(columnName), rs.getString(i), !rs.wasNull(), rowCount);
                        continue block19;
                    }
                    case 91: {
                        JdbcToArrowUtils.updateVector((DateMilliVector)root.getVector(columnName), rs.getDate(i, calendar), !rs.wasNull(), rowCount);
                        continue block19;
                    }
                    case 92: {
                        JdbcToArrowUtils.updateVector((TimeMilliVector)root.getVector(columnName), rs.getTime(i, calendar), !rs.wasNull(), rowCount);
                        continue block19;
                    }
                    case 93: {
                        JdbcToArrowUtils.updateVector((TimeStampVector)root.getVector(columnName), rs.getTimestamp(i, calendar), !rs.wasNull(), rowCount);
                        continue block19;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        JdbcToArrowUtils.updateVector((VarBinaryVector)root.getVector(columnName), rs.getBinaryStream(i), !rs.wasNull(), rowCount);
                        continue block19;
                    }
                    case 2003: {
                        continue block19;
                    }
                    case 2005: {
                        JdbcToArrowUtils.updateVector((VarCharVector)root.getVector(columnName), rs.getClob(i), !rs.wasNull(), rowCount);
                        continue block19;
                    }
                    case 2004: {
                        JdbcToArrowUtils.updateVector((VarBinaryVector)root.getVector(columnName), rs.getBlob(i), !rs.wasNull(), rowCount);
                        continue block19;
                    }
                }
            }
            ++rowCount;
        }
        root.setRowCount(rowCount);
    }

    private static void updateVector(BitVector bitVector, boolean value, boolean isNonNull, int rowCount) {
        NullableBitHolder holder = new NullableBitHolder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.value = value ? 1 : 0;
        }
        bitVector.setSafe(rowCount, holder);
        bitVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(TinyIntVector tinyIntVector, int value, boolean isNonNull, int rowCount) {
        NullableTinyIntHolder holder = new NullableTinyIntHolder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.value = (byte)value;
        }
        tinyIntVector.setSafe(rowCount, holder);
        tinyIntVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(SmallIntVector smallIntVector, int value, boolean isNonNull, int rowCount) {
        NullableSmallIntHolder holder = new NullableSmallIntHolder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.value = (short)value;
        }
        smallIntVector.setSafe(rowCount, holder);
        smallIntVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(IntVector intVector, int value, boolean isNonNull, int rowCount) {
        NullableIntHolder holder = new NullableIntHolder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.value = value;
        }
        intVector.setSafe(rowCount, holder);
        intVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(BigIntVector bigIntVector, long value, boolean isNonNull, int rowCount) {
        NullableBigIntHolder holder = new NullableBigIntHolder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.value = value;
        }
        bigIntVector.setSafe(rowCount, holder);
        bigIntVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(DecimalVector decimalVector, BigDecimal value, boolean isNonNull, int rowCount) {
        NullableDecimalHolder holder = new NullableDecimalHolder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.precision = value.precision();
            holder.scale = value.scale();
            holder.buffer = decimalVector.getAllocator().buffer(256);
            holder.start = 0;
            DecimalUtility.writeBigDecimalToArrowBuf((BigDecimal)value, (ArrowBuf)holder.buffer, (int)holder.start);
        }
        decimalVector.setSafe(rowCount, holder);
        decimalVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(Float4Vector float4Vector, float value, boolean isNonNull, int rowCount) {
        NullableFloat4Holder holder = new NullableFloat4Holder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.value = value;
        }
        float4Vector.setSafe(rowCount, holder);
        float4Vector.setValueCount(rowCount + 1);
    }

    private static void updateVector(Float8Vector float8Vector, double value, boolean isNonNull, int rowCount) {
        NullableFloat8Holder holder = new NullableFloat8Holder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.value = value;
        }
        float8Vector.setSafe(rowCount, holder);
        float8Vector.setValueCount(rowCount + 1);
    }

    private static void updateVector(VarCharVector varcharVector, String value, boolean isNonNull, int rowCount) {
        NullableVarCharHolder holder = new NullableVarCharHolder();
        holder.isSet = isNonNull ? 1 : 0;
        varcharVector.setIndexDefined(rowCount);
        if (isNonNull) {
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            holder.buffer = varcharVector.getAllocator().buffer(bytes.length);
            holder.buffer.setBytes(0, bytes, 0, bytes.length);
            holder.start = 0;
            holder.end = bytes.length;
        } else {
            holder.buffer = varcharVector.getAllocator().buffer(0);
        }
        varcharVector.setSafe(rowCount, holder);
        varcharVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(DateMilliVector dateMilliVector, Date date, boolean isNonNull, int rowCount) {
        NullableDateMilliHolder holder = new NullableDateMilliHolder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull) {
            holder.value = date.getTime();
        }
        dateMilliVector.setSafe(rowCount, holder);
        dateMilliVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(TimeMilliVector timeMilliVector, Time time, boolean isNonNull, int rowCount) {
        NullableTimeMilliHolder holder = new NullableTimeMilliHolder();
        int n = holder.isSet = isNonNull ? 1 : 0;
        if (isNonNull && time != null) {
            holder.value = (int)time.getTime();
        }
        timeMilliVector.setSafe(rowCount, holder);
        timeMilliVector.setValueCount(rowCount + 1);
    }

    private static void updateVector(TimeStampVector timeStampVector, Timestamp timestamp, boolean isNonNull, int rowCount) {
        timeStampVector.setValueCount(rowCount + 1);
        if (timestamp != null) {
            timeStampVector.setSafe(rowCount, timestamp.getTime());
        } else {
            timeStampVector.setNull(rowCount);
        }
    }

    private static void updateVector(VarBinaryVector varBinaryVector, InputStream is, boolean isNonNull, int rowCount) throws IOException {
        varBinaryVector.setValueCount(rowCount + 1);
        if (isNonNull && is != null) {
            int read;
            VarBinaryHolder holder = new VarBinaryHolder();
            ArrowBuf arrowBuf = varBinaryVector.getDataBuffer();
            holder.start = 0;
            byte[] bytes = new byte[1024];
            int total = 0;
            while ((read = is.read(bytes, 0, 1024)) != -1) {
                arrowBuf.setBytes(total, bytes, total, read);
                total += read;
            }
            holder.end = total;
            holder.buffer = arrowBuf;
            varBinaryVector.set(rowCount, holder);
            varBinaryVector.setIndexDefined(rowCount);
        } else {
            varBinaryVector.setNull(rowCount);
        }
    }

    private static void updateVector(VarCharVector varcharVector, Clob clob, boolean isNonNull, int rowCount) throws SQLException, IOException {
        varcharVector.setValueCount(rowCount + 1);
        if (isNonNull && clob != null) {
            VarCharHolder holder = new VarCharHolder();
            ArrowBuf arrowBuf = varcharVector.getDataBuffer();
            holder.start = 0;
            long length = clob.length();
            int read = 1;
            int readSize = length < 256L ? (int)length : 256;
            int totalBytes = 0;
            while ((long)read <= length) {
                String str = clob.getSubString(read, readSize);
                byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
                arrowBuf.setBytes(totalBytes, (InputStream)new ByteArrayInputStream(bytes, 0, bytes.length), bytes.length);
                totalBytes += bytes.length;
                read += readSize;
            }
            holder.end = totalBytes;
            holder.buffer = arrowBuf;
            varcharVector.set(rowCount, holder);
            varcharVector.setIndexDefined(rowCount);
        } else {
            varcharVector.setNull(rowCount);
        }
    }

    private static void updateVector(VarBinaryVector varBinaryVector, Blob blob, boolean isNonNull, int rowCount) throws SQLException, IOException {
        JdbcToArrowUtils.updateVector(varBinaryVector, blob != null ? blob.getBinaryStream() : null, isNonNull, rowCount);
    }
}

