/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.jdbc;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.arrow.adapter.jdbc.JdbcToArrowUtils;
import org.apache.arrow.memory.BaseAllocator;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;

public class JdbcToArrow {
    public static VectorSchemaRoot sqlToArrow(Connection connection, String query, BaseAllocator allocator) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)connection, (Object)"JDBC connection object can not be null");
        Preconditions.checkArgument((query != null && query.length() > 0 ? 1 : 0) != 0, (Object)"SQL query can not be null or empty");
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory allocator object can not be null");
        return JdbcToArrow.sqlToArrow(connection, query, allocator, Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT));
    }

    public static VectorSchemaRoot sqlToArrow(Connection connection, String query, BaseAllocator allocator, Calendar calendar) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)connection, (Object)"JDBC connection object can not be null");
        Preconditions.checkArgument((query != null && query.length() > 0 ? 1 : 0) != 0, (Object)"SQL query can not be null or empty");
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory allocator object can not be null");
        Preconditions.checkNotNull((Object)calendar, (Object)"Calendar object can not be null");
        try (Statement stmt = connection.createStatement();){
            VectorSchemaRoot vectorSchemaRoot = JdbcToArrow.sqlToArrow(stmt.executeQuery(query), allocator, calendar);
            return vectorSchemaRoot;
        }
    }

    public static VectorSchemaRoot sqlToArrow(ResultSet resultSet) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)resultSet, (Object)"JDBC ResultSet object can not be null");
        return JdbcToArrow.sqlToArrow(resultSet, Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT));
    }

    public static VectorSchemaRoot sqlToArrow(ResultSet resultSet, BaseAllocator allocator) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)resultSet, (Object)"JDBC ResultSet object can not be null");
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory Allocator object can not be null");
        return JdbcToArrow.sqlToArrow(resultSet, allocator, Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT));
    }

    public static VectorSchemaRoot sqlToArrow(ResultSet resultSet, Calendar calendar) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)resultSet, (Object)"JDBC ResultSet object can not be null");
        Preconditions.checkNotNull((Object)calendar, (Object)"Calendar object can not be null");
        RootAllocator rootAllocator = new RootAllocator(Integer.MAX_VALUE);
        VectorSchemaRoot root = JdbcToArrow.sqlToArrow(resultSet, (BaseAllocator)rootAllocator, calendar);
        return root;
    }

    public static VectorSchemaRoot sqlToArrow(ResultSet resultSet, BaseAllocator allocator, Calendar calendar) throws SQLException, IOException {
        Preconditions.checkNotNull((Object)resultSet, (Object)"JDBC ResultSet object can not be null");
        Preconditions.checkNotNull((Object)allocator, (Object)"Memory Allocator object can not be null");
        Preconditions.checkNotNull((Object)calendar, (Object)"Calendar object can not be null");
        VectorSchemaRoot root = VectorSchemaRoot.create((Schema)JdbcToArrowUtils.jdbcToArrowSchema(resultSet.getMetaData(), calendar), (BufferAllocator)allocator);
        JdbcToArrowUtils.jdbcToArrowVectors(resultSet, root, calendar);
        return root;
    }
}

