/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flatbuf;

import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.arrow.flatbuf.Buffer;
import org.apache.arrow.flatbuf.FieldNode;

public final class RecordBatch
extends Table {
    public static RecordBatch getRootAsRecordBatch(ByteBuffer _bb) {
        return RecordBatch.getRootAsRecordBatch(_bb, new RecordBatch());
    }

    public static RecordBatch getRootAsRecordBatch(ByteBuffer _bb, RecordBatch obj) {
        _bb.order(ByteOrder.LITTLE_ENDIAN);
        return obj.__init(_bb.getInt(_bb.position()) + _bb.position(), _bb);
    }

    public RecordBatch __init(int _i, ByteBuffer _bb) {
        this.bb_pos = _i;
        this.bb = _bb;
        return this;
    }

    public int length() {
        int o = this.__offset(4);
        return o != 0 ? this.bb.getInt(o + this.bb_pos) : 0;
    }

    public FieldNode nodes(int j) {
        return this.nodes(new FieldNode(), j);
    }

    public FieldNode nodes(FieldNode obj, int j) {
        int o = this.__offset(6);
        return o != 0 ? obj.__init(this.__vector(o) + j * 8, this.bb) : null;
    }

    public int nodesLength() {
        int o = this.__offset(6);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public Buffer buffers(int j) {
        return this.buffers(new Buffer(), j);
    }

    public Buffer buffers(Buffer obj, int j) {
        int o = this.__offset(8);
        return o != 0 ? obj.__init(this.__vector(o) + j * 24, this.bb) : null;
    }

    public int buffersLength() {
        int o = this.__offset(8);
        return o != 0 ? this.__vector_len(o) : 0;
    }

    public static int createRecordBatch(FlatBufferBuilder builder, int length, int nodes, int buffers) {
        builder.startObject(3);
        RecordBatch.addBuffers(builder, buffers);
        RecordBatch.addNodes(builder, nodes);
        RecordBatch.addLength(builder, length);
        return RecordBatch.endRecordBatch(builder);
    }

    public static void startRecordBatch(FlatBufferBuilder builder) {
        builder.startObject(3);
    }

    public static void addLength(FlatBufferBuilder builder, int length) {
        builder.addInt(0, length, 0);
    }

    public static void addNodes(FlatBufferBuilder builder, int nodesOffset) {
        builder.addOffset(1, nodesOffset, 0);
    }

    public static void startNodesVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(8, numElems, 4);
    }

    public static void addBuffers(FlatBufferBuilder builder, int buffersOffset) {
        builder.addOffset(2, buffersOffset, 0);
    }

    public static void startBuffersVector(FlatBufferBuilder builder, int numElems) {
        builder.startVector(24, numElems, 8);
    }

    public static int endRecordBatch(FlatBufferBuilder builder) {
        int o = builder.endObject();
        return o;
    }
}

