/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import io.grpc.stub.StreamObserver;
import java.util.function.Function;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.grpc.StatusUtils;

class StreamPipe<FROM, TO>
implements FlightProducer.StreamListener<FROM> {
    private StreamObserver<TO> delegate;
    private Function<FROM, TO> mapFunction;
    private boolean closed = false;

    public static <FROM, TO> StreamPipe<FROM, TO> wrap(StreamObserver<TO> delegate, Function<FROM, TO> func) {
        return new StreamPipe<FROM, TO>(delegate, func);
    }

    public StreamPipe(StreamObserver<TO> delegate, Function<FROM, TO> func) {
        this.delegate = delegate;
        this.mapFunction = func;
    }

    @Override
    public void onNext(FROM val) {
        this.delegate.onNext(this.mapFunction.apply(val));
    }

    @Override
    public void onError(Throwable t) {
        this.delegate.onError(StatusUtils.toGrpcException(t));
        this.closed = true;
    }

    @Override
    public void onCompleted() {
        this.delegate.onCompleted();
        this.closed = true;
    }

    public void ensureCompleted() {
        if (!this.closed) {
            this.onCompleted();
        }
    }
}

