/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.collect.ImmutableList;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.impl.Flight;

public class FlightEndpoint {
    private List<Location> locations;
    private Ticket ticket;

    public FlightEndpoint(Ticket ticket, Location ... locations) {
        Objects.requireNonNull(ticket);
        this.locations = ImmutableList.copyOf((Object[])locations);
        this.ticket = ticket;
    }

    FlightEndpoint(Flight.FlightEndpoint flt) throws URISyntaxException {
        this.locations = new ArrayList<Location>();
        for (Flight.Location location : flt.getLocationList()) {
            this.locations.add(new Location(location.getUri()));
        }
        this.ticket = new Ticket(flt.getTicket());
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    Flight.FlightEndpoint toProtocol() {
        Flight.FlightEndpoint.Builder b = Flight.FlightEndpoint.newBuilder().setTicket(this.ticket.toProtocol());
        for (Location l : this.locations) {
            b.addLocation(l.toProtocol());
        }
        return b.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlightEndpoint that = (FlightEndpoint)o;
        return this.locations.equals(that.locations) && this.ticket.equals(that.ticket);
    }

    public int hashCode() {
        return Objects.hash(this.locations, this.ticket);
    }

    public String toString() {
        return "FlightEndpoint{locations=" + this.locations + ", ticket=" + this.ticket + '}';
    }
}

