/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.flight.FlightBindingService;
import org.apache.arrow.flight.FlightProducer;
import org.apache.arrow.flight.auth.ServerAuthHandler;
import org.apache.arrow.flight.auth.ServerAuthInterceptor;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlightServer
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(FlightServer.class);
    private final Server server;
    static final int MAX_GRPC_MESSAGE_SIZE = Integer.MAX_VALUE;

    public FlightServer(BufferAllocator allocator, int port, FlightProducer producer, ServerAuthHandler authHandler) {
        this.server = ServerBuilder.forPort((int)port).maxInboundMessageSize(Integer.MAX_VALUE).addService(ServerInterceptors.intercept((BindableService)new FlightBindingService(allocator, producer, authHandler), (ServerInterceptor[])new ServerInterceptor[]{new ServerAuthInterceptor(authHandler)})).build();
    }

    public FlightServer start() throws IOException {
        this.server.start();
        return this;
    }

    public int getPort() {
        return this.server.getPort();
    }

    @Override
    public void close() throws InterruptedException {
        this.server.shutdown();
        boolean terminated = this.server.awaitTermination(3000L, TimeUnit.MILLISECONDS);
        if (terminated) {
            logger.debug("Server was terminated within 3s");
            return;
        }
        this.server.shutdownNow();
        int count = 0;
        while (!this.server.isTerminated() & count < 30) {
            ++count;
            logger.debug("Waiting for termination");
            Thread.sleep(100L);
        }
        if (!this.server.isTerminated()) {
            logger.warn("Couldn't shutdown server, resources likely will be leaked.");
        }
    }

    public static interface FlightServerHandler {
        public Flight.FlightGetInfo getFlightInfo(String var1) throws Exception;

        public OutputFlight setupFlight(VectorSchemaRoot var1);
    }

    public static interface OutputFlight {
        public void sendData(int var1);

        public void done();

        public void fail(Throwable var1);
    }
}

