/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteStreams;
import com.google.flatbuffers.FlatBufferBuilder;
import com.google.flatbuffers.Table;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Message;
import io.grpc.Drainable;
import io.grpc.MethodDescriptor;
import io.grpc.internal.ReadableBuffer;
import io.grpc.protobuf.ProtoUtils;
import io.netty.buffer.ArrowBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.arrow.flatbuf.RecordBatch;
import org.apache.arrow.flatbuf.Schema;
import org.apache.arrow.flight.grpc.AddWritableBuffer;
import org.apache.arrow.flight.grpc.GetReadableBuffer;
import org.apache.arrow.flight.impl.Flight;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageSerializer;

class ArrowMessage
implements AutoCloseable {
    public static final boolean FAST_PATH = true;
    private static final int DESCRIPTOR_TAG = 10;
    private static final int BODY_TAG = 8002;
    private static final int HEADER_TAG = 18;
    private static MethodDescriptor.Marshaller<Flight.FlightData> NO_BODY_MARSHALLER = ProtoUtils.marshaller((Message)Flight.FlightData.getDefaultInstance());
    private static List<ByteBuf> PADDING_BUFFERS = Arrays.asList(null, Unpooled.copiedBuffer((byte[])new byte[]{0}), Unpooled.copiedBuffer((byte[])new byte[]{0, 0}), Unpooled.copiedBuffer((byte[])new byte[]{0, 0, 0}), Unpooled.copiedBuffer((byte[])new byte[]{0, 0, 0, 0}), Unpooled.copiedBuffer((byte[])new byte[]{0, 0, 0, 0, 0}), Unpooled.copiedBuffer((byte[])new byte[]{0, 0, 0, 0, 0, 0}), Unpooled.copiedBuffer((byte[])new byte[]{0, 0, 0, 0, 0, 0, 0}));
    private final Flight.FlightDescriptor descriptor;
    private final org.apache.arrow.flatbuf.Message message;
    private final List<ArrowBuf> bufs;

    public ArrowMessage(Flight.FlightDescriptor descriptor, org.apache.arrow.vector.types.pojo.Schema schema) {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        int schemaOffset = schema.getSchema(builder);
        ByteBuffer serializedMessage = MessageSerializer.serializeMessage((FlatBufferBuilder)builder, (byte)1, (int)schemaOffset, (int)0);
        serializedMessage = serializedMessage.slice();
        this.message = org.apache.arrow.flatbuf.Message.getRootAsMessage((ByteBuffer)serializedMessage);
        this.bufs = ImmutableList.of();
        this.descriptor = descriptor;
    }

    public ArrowMessage(ArrowRecordBatch batch) {
        FlatBufferBuilder builder = new FlatBufferBuilder();
        int batchOffset = batch.writeTo(builder);
        ByteBuffer serializedMessage = MessageSerializer.serializeMessage((FlatBufferBuilder)builder, (byte)3, (int)batchOffset, (int)batch.computeBodyLength());
        serializedMessage = serializedMessage.slice();
        this.message = org.apache.arrow.flatbuf.Message.getRootAsMessage((ByteBuffer)serializedMessage);
        this.bufs = ImmutableList.copyOf((Collection)batch.getBuffers());
        this.descriptor = null;
    }

    private ArrowMessage(Flight.FlightDescriptor descriptor, org.apache.arrow.flatbuf.Message message, ArrowBuf buf) {
        this.message = message;
        this.descriptor = descriptor;
        this.bufs = buf == null ? ImmutableList.of() : ImmutableList.of((Object)buf);
    }

    public Flight.FlightDescriptor getDescriptor() {
        return this.descriptor;
    }

    public HeaderType getMessageType() {
        return HeaderType.getHeader(this.message.headerType());
    }

    public org.apache.arrow.flatbuf.Message asSchemaMessage() {
        return this.message;
    }

    public org.apache.arrow.vector.types.pojo.Schema asSchema() {
        Preconditions.checkArgument((this.bufs.size() == 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.getMessageType() == HeaderType.SCHEMA ? 1 : 0) != 0);
        Schema schema = new Schema();
        this.message.header((Table)schema);
        return org.apache.arrow.vector.types.pojo.Schema.convertSchema((Schema)schema);
    }

    public ArrowRecordBatch asRecordBatch() throws IOException {
        Preconditions.checkArgument((this.bufs.size() == 1 ? 1 : 0) != 0, (Object)"A batch can only be consumed if it contains a single ArrowBuf.");
        Preconditions.checkArgument((this.getMessageType() == HeaderType.RECORD_BATCH ? 1 : 0) != 0);
        RecordBatch recordBatch = new RecordBatch();
        this.message.header((Table)recordBatch);
        ArrowBuf underlying = this.bufs.get(0);
        ArrowRecordBatch batch = MessageSerializer.deserializeRecordBatch((RecordBatch)recordBatch, (ArrowBuf)underlying);
        return batch;
    }

    public Iterable<ArrowBuf> getBufs() {
        return Iterables.unmodifiableIterable(this.bufs);
    }

    private static ArrowMessage frame(BufferAllocator allocator, InputStream stream) {
        try {
            Flight.FlightDescriptor descriptor = null;
            org.apache.arrow.flatbuf.Message header = null;
            ArrowBuf body = null;
            while (stream.available() > 0) {
                int tag = ArrowMessage.readRawVarint32(stream);
                switch (tag) {
                    case 10: {
                        int size = ArrowMessage.readRawVarint32(stream);
                        byte[] bytes = new byte[size];
                        ByteStreams.readFully((InputStream)stream, (byte[])bytes);
                        descriptor = Flight.FlightDescriptor.parseFrom(bytes);
                        break;
                    }
                    case 18: {
                        int size = ArrowMessage.readRawVarint32(stream);
                        byte[] bytes = new byte[size];
                        ByteStreams.readFully((InputStream)stream, (byte[])bytes);
                        header = org.apache.arrow.flatbuf.Message.getRootAsMessage((ByteBuffer)ByteBuffer.wrap(bytes));
                        break;
                    }
                    case 8002: {
                        if (body != null) {
                            body.release();
                            body = null;
                        }
                        int size = ArrowMessage.readRawVarint32(stream);
                        body = allocator.buffer(size);
                        ReadableBuffer readableBuffer = GetReadableBuffer.getReadableBuffer(stream);
                        if (readableBuffer != null) {
                            readableBuffer.readBytes(body.nioBuffer(0, size));
                        } else {
                            byte[] heapBytes = new byte[size];
                            ByteStreams.readFully((InputStream)stream, (byte[])heapBytes);
                            body.writeBytes(heapBytes);
                        }
                        body.writerIndex(size);
                        break;
                    }
                }
            }
            return new ArrowMessage(descriptor, header, body);
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static int readRawVarint32(InputStream is) throws IOException {
        int firstByte = is.read();
        return CodedInputStream.readRawVarint32((int)firstByte, (InputStream)is);
    }

    private InputStream asInputStream(BufferAllocator allocator) {
        try {
            ByteString bytes = ByteString.copyFrom((ByteBuffer)this.message.getByteBuffer(), (int)this.message.getByteBuffer().remaining());
            if (this.getMessageType() == HeaderType.SCHEMA) {
                Flight.FlightData.Builder builder = Flight.FlightData.newBuilder().setDataHeader(bytes);
                if (this.descriptor != null) {
                    builder.setFlightDescriptor(this.descriptor);
                }
                Preconditions.checkArgument((boolean)this.bufs.isEmpty());
                return NO_BODY_MARSHALLER.stream((Object)builder.build());
            }
            Preconditions.checkArgument((this.getMessageType() == HeaderType.RECORD_BATCH ? 1 : 0) != 0);
            Preconditions.checkArgument((!this.bufs.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkArgument((this.descriptor == null ? 1 : 0) != 0, (Object)"Descriptor should only be included in the schema message.");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CodedOutputStream cos = CodedOutputStream.newInstance((OutputStream)baos);
            cos.writeBytes(2, bytes);
            cos.writeTag(1000, 2);
            int size = 0;
            ArrayList<Object> allBufs = new ArrayList<Object>();
            for (ArrowBuf b : this.bufs) {
                allBufs.add(b);
                size += b.readableBytes();
                if (b.readableBytes() % 8 == 0) continue;
                int paddingBytes = 8 - b.readableBytes() % 8;
                assert (paddingBytes > 0 && paddingBytes < 8);
                size += paddingBytes;
                allBufs.add(PADDING_BUFFERS.get(paddingBytes).retain());
            }
            cos.writeUInt32NoTag(size);
            cos.flush();
            ArrowBuf initialBuf = allocator.buffer(baos.size());
            initialBuf.writeBytes(baos.toByteArray());
            CompositeByteBuf bb = new CompositeByteBuf(allocator.getAsByteBufAllocator(), true, this.bufs.size() + 1, (Iterable)ImmutableList.builder().add((Object)initialBuf).addAll(allBufs).build());
            DrainableByteBufInputStream is = new DrainableByteBufInputStream(bb);
            return is;
        }
        catch (Exception ex) {
            throw new RuntimeException("Unexpected IO Exception", ex);
        }
    }

    public static MethodDescriptor.Marshaller<ArrowMessage> createMarshaller(BufferAllocator allocator) {
        return new ArrowMessageHolderMarshaller(allocator);
    }

    @Override
    public void close() throws Exception {
        AutoCloseables.close(this.bufs);
    }

    private static class ArrowMessageHolderMarshaller
    implements MethodDescriptor.Marshaller<ArrowMessage> {
        private final BufferAllocator allocator;

        public ArrowMessageHolderMarshaller(BufferAllocator allocator) {
            this.allocator = allocator;
        }

        public InputStream stream(ArrowMessage value) {
            return value.asInputStream(this.allocator);
        }

        public ArrowMessage parse(InputStream stream) {
            return ArrowMessage.frame(this.allocator, stream);
        }
    }

    private class DrainableByteBufInputStream
    extends ByteBufInputStream
    implements Drainable {
        private final CompositeByteBuf buf;

        public DrainableByteBufInputStream(CompositeByteBuf buffer) {
            super((ByteBuf)buffer, buffer.readableBytes(), true);
            this.buf = buffer;
        }

        public int drainTo(OutputStream target) throws IOException {
            int size = this.buf.readableBytes();
            if (AddWritableBuffer.add((ByteBuf)this.buf, target)) {
                return size;
            }
            this.buf.getBytes(0, target, this.buf.readableBytes());
            return size;
        }

        public void close() throws IOException {
            this.buf.release();
        }
    }

    public static enum HeaderType {
        NONE,
        SCHEMA,
        DICTIONARY_BATCH,
        RECORD_BATCH,
        TENSOR;


        public static HeaderType getHeader(byte b) {
            switch (b) {
                case 0: {
                    return NONE;
                }
                case 1: {
                    return SCHEMA;
                }
                case 2: {
                    return DICTIONARY_BATCH;
                }
                case 3: {
                    return RECORD_BATCH;
                }
                case 4: {
                    return TENSOR;
                }
            }
            throw new UnsupportedOperationException("unknown type: " + b);
        }
    }
}

