/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.example;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.List;
import org.apache.arrow.flight.Ticket;

@JsonSerialize
public class ExampleTicket {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final List<String> path;
    private final int ordinal;
    private final String uuid;

    @JsonCreator
    public ExampleTicket(@JsonProperty(value="path") List<String> path, @JsonProperty(value="ordinal") int ordinal, @JsonProperty(value="uuid") String uuid) {
        Preconditions.checkArgument((ordinal >= 0 ? 1 : 0) != 0);
        this.path = path;
        this.ordinal = ordinal;
        this.uuid = uuid;
    }

    public List<String> getPath() {
        return this.path;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getUuid() {
        return this.uuid;
    }

    public static ExampleTicket from(Ticket ticket) {
        try {
            return (ExampleTicket)MAPPER.readValue(ticket.getBytes(), ExampleTicket.class);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Ticket toTicket() {
        try {
            return new Ticket(MAPPER.writeValueAsBytes((Object)this));
        }
        catch (JsonProcessingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.ordinal;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExampleTicket other = (ExampleTicket)obj;
        if (this.ordinal != other.ordinal) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }
}

