/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.impl.Flight;

public class FlightEndpoint {
    private List<Location> locations;
    private Ticket ticket;

    public FlightEndpoint(Ticket ticket, Location ... locations) {
        this.locations = ImmutableList.copyOf((Object[])locations);
        this.ticket = ticket;
    }

    public FlightEndpoint(Flight.FlightEndpoint flt) {
        this.locations = flt.getLocationList().stream().map(t -> new Location((Flight.Location)t)).collect(Collectors.toList());
        this.ticket = new Ticket(flt.getTicket());
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    Flight.FlightEndpoint toProtocol() {
        Flight.FlightEndpoint.Builder b = Flight.FlightEndpoint.newBuilder().setTicket(this.ticket.toProtocol());
        for (Location l : this.locations) {
            b.addLocation(Flight.Location.newBuilder().setHost(l.getHost()).setPort(l.getPort()).build());
        }
        return b.build();
    }
}

