/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.memory;

import org.apache.arrow.dataset.jni.JniWrapper;
import org.apache.arrow.memory.AllocationListener;
import org.apache.arrow.memory.AllocationManager;
import org.apache.arrow.memory.AllocationReservation;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.BufferLedger;

public class NativeUnderlyingMemory
extends AllocationManager {
    private final int size;
    private final long nativeInstanceId;
    private final long address;

    NativeUnderlyingMemory(BufferAllocator accountingAllocator, int size, long nativeInstanceId, long address) {
        super(accountingAllocator);
        this.size = size;
        this.nativeInstanceId = nativeInstanceId;
        this.address = address;
        AllocationListener listener = accountingAllocator.getListener();
        try (AllocationReservation reservation = accountingAllocator.newReservation();){
            listener.onPreAllocation((long)size);
            reservation.reserve(size);
            listener.onAllocation((long)size);
        }
        catch (Exception e) {
            this.release0();
            throw e;
        }
    }

    public static NativeUnderlyingMemory create(BufferAllocator bufferAllocator, int size, long nativeInstanceId, long address) {
        return new NativeUnderlyingMemory(bufferAllocator, size, nativeInstanceId, address);
    }

    public BufferLedger associate(BufferAllocator allocator) {
        return super.associate(allocator);
    }

    protected void release0() {
        JniWrapper.get().releaseBuffer(this.nativeInstanceId);
    }

    public long getSize() {
        return this.size;
    }

    protected long memoryAddress() {
        return this.address;
    }
}

