/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.dataset.jni;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.arrow.dataset.jni.JniWrapper;

public final class JniLoader {
    private static final JniLoader INSTANCE = new JniLoader(Collections.singletonList("arrow_dataset_jni"));
    private final Set<String> librariesToLoad;

    public static JniLoader get() {
        return INSTANCE;
    }

    private JniLoader(List<String> libraryNames) {
        this.librariesToLoad = new HashSet<String>(libraryNames);
    }

    private boolean finished() {
        return this.librariesToLoad.isEmpty();
    }

    public void ensureLoaded() {
        if (this.finished()) {
            return;
        }
        this.loadRemaining();
    }

    private synchronized void loadRemaining() {
        if (this.finished()) {
            return;
        }
        ArrayList<String> libs = new ArrayList<String>(this.librariesToLoad);
        for (String lib : libs) {
            this.load(lib);
            this.librariesToLoad.remove(lib);
        }
    }

    private void load(String name) {
        String libraryToLoad = System.mapLibraryName(name);
        try {
            File temp = File.createTempFile("jnilib-", ".tmp", new File(System.getProperty("java.io.tmpdir")));
            temp.deleteOnExit();
            try (InputStream is = JniWrapper.class.getClassLoader().getResourceAsStream(libraryToLoad);){
                if (is == null) {
                    throw new FileNotFoundException(libraryToLoad);
                }
                Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                System.load(temp.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("error loading native libraries: " + e);
        }
    }
}

