/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.c;

import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.c.ArrowArray;
import org.apache.arrow.c.NativeUtil;
import org.apache.arrow.c.jni.JniWrapper;
import org.apache.arrow.c.jni.PrivateData;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.dictionary.Dictionary;
import org.apache.arrow.vector.dictionary.DictionaryProvider;
import org.apache.arrow.vector.types.pojo.DictionaryEncoding;

final class ArrayExporter {
    private final BufferAllocator allocator;

    public ArrayExporter(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    void export(ArrowArray array, FieldVector vector, DictionaryProvider dictionaryProvider) {
        List children = vector.getChildrenFromFields();
        int valueCount = vector.getValueCount();
        int nullCount = vector.getNullCount();
        DictionaryEncoding dictionaryEncoding = vector.getField().getDictionary();
        ExportedArrayPrivateData data = new ExportedArrayPrivateData();
        try {
            if (children != null) {
                data.children = new ArrayList<ArrowArray>(children.size());
                data.children_ptrs = this.allocator.buffer((long)children.size() * 8L);
                for (int i = 0; i < children.size(); ++i) {
                    ArrowArray child = ArrowArray.allocateNew(this.allocator);
                    data.children.add(child);
                    data.children_ptrs.writeLong(child.memoryAddress());
                }
            }
            data.buffers = new ArrayList<ArrowBuf>(vector.getExportedCDataBufferCount());
            data.buffers_ptrs = this.allocator.buffer((long)vector.getExportedCDataBufferCount() * 8L);
            vector.exportCDataBuffers(data.buffers, data.buffers_ptrs, 0L);
            if (dictionaryEncoding != null) {
                Dictionary dictionary = dictionaryProvider.lookup(dictionaryEncoding.getId());
                Preconditions.checkNotNull((Object)dictionary, (Object)"Dictionary lookup failed on export of dictionary encoded array");
                data.dictionary = ArrowArray.allocateNew(this.allocator);
                FieldVector dictionaryVector = dictionary.getVector();
                this.export(data.dictionary, dictionaryVector, dictionaryProvider);
            }
            ArrowArray.Snapshot snapshot = new ArrowArray.Snapshot();
            snapshot.length = valueCount;
            snapshot.null_count = nullCount;
            snapshot.offset = 0L;
            snapshot.n_buffers = data.buffers != null ? (long)data.buffers.size() : 0L;
            snapshot.n_children = data.children != null ? (long)data.children.size() : 0L;
            snapshot.buffers = NativeUtil.addressOrNull(data.buffers_ptrs);
            snapshot.children = NativeUtil.addressOrNull(data.children_ptrs);
            snapshot.dictionary = NativeUtil.addressOrNull(data.dictionary);
            snapshot.release = 0L;
            array.save(snapshot);
            JniWrapper.get().exportArray(array.memoryAddress(), data);
        }
        catch (Exception e) {
            data.close();
            throw e;
        }
        if (children != null) {
            for (int i = 0; i < children.size(); ++i) {
                FieldVector childVector = (FieldVector)children.get(i);
                ArrowArray child = data.children.get(i);
                this.export(child, childVector, dictionaryProvider);
            }
        }
    }

    static class ExportedArrayPrivateData
    implements PrivateData {
        ArrowBuf buffers_ptrs;
        List<ArrowBuf> buffers;
        ArrowBuf children_ptrs;
        List<ArrowArray> children;
        ArrowArray dictionary;

        ExportedArrayPrivateData() {
        }

        @Override
        public void close() {
            NativeUtil.closeBuffer(this.buffers_ptrs);
            if (this.buffers != null) {
                for (ArrowBuf buffer : this.buffers) {
                    NativeUtil.closeBuffer(buffer);
                }
            }
            NativeUtil.closeBuffer(this.children_ptrs);
            if (this.children != null) {
                for (ArrowArray child : this.children) {
                    child.close();
                }
            }
            if (this.dictionary != null) {
                this.dictionary.close();
            }
        }
    }
}

