/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers.logical;

import java.io.IOException;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.vector.TimeStampSecVector;
import org.apache.avro.io.Encoder;

public class AvroTimestampSecProducer
extends BaseAvroProducer<TimeStampSecVector> {
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long OVERFLOW_LIMIT = 9223372036854775L;

    public AvroTimestampSecProducer(TimeStampSecVector vector) {
        super(vector);
    }

    @Override
    public void produce(Encoder encoder) throws IOException {
        long seconds = ((TimeStampSecVector)this.vector).getDataBuffer().getLong((long)this.currentIndex * 8L);
        if (Math.abs(seconds) > 9223372036854775L) {
            throw new ArithmeticException("Timestamp value is too large for Avro encoding");
        }
        long millis = seconds * 1000L;
        encoder.writeLong(millis);
        ++this.currentIndex;
    }
}

