/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers.logical;

import java.io.IOException;
import java.math.BigDecimal;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.util.DecimalUtility;
import org.apache.avro.io.Encoder;

public class AvroDecimalProducer
extends BaseAvroProducer<DecimalVector> {
    byte[] encodedBytes = new byte[16];

    public AvroDecimalProducer(DecimalVector vector) {
        super(vector);
    }

    @Override
    public void produce(Encoder encoder) throws IOException {
        BigDecimal value = ((DecimalVector)this.vector).getObject(this.currentIndex++);
        AvroDecimalProducer.encodeDecimal(value, this.encodedBytes);
        encoder.writeFixed(this.encodedBytes);
    }

    static void encodeDecimal(BigDecimal value, byte[] encodedBytes) {
        byte[] valueBytes = value.unscaledValue().toByteArray();
        byte[] padding = valueBytes[0] < 0 ? DecimalUtility.minus_one : DecimalUtility.zeroes;
        System.arraycopy(padding, 0, encodedBytes, 0, encodedBytes.length - valueBytes.length);
        System.arraycopy(valueBytes, 0, encodedBytes, encodedBytes.length - valueBytes.length, valueBytes.length);
    }
}

