/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers.logical;

import java.io.IOException;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.avro.io.Encoder;

public class AvroDateMilliProducer
extends BaseAvroProducer<DateMilliVector> {
    private static final long MILLIS_PER_DAY = 86400000L;

    public AvroDateMilliProducer(DateMilliVector vector) {
        super(vector);
    }

    @Override
    public void produce(Encoder encoder) throws IOException {
        long millis = ((DateMilliVector)this.vector).getDataBuffer().getLong((long)this.currentIndex * 8L);
        long days = millis / 86400000L;
        if (days > Integer.MAX_VALUE || days < Integer.MIN_VALUE) {
            throw new ArithmeticException("Date value is too large for Avro encoding");
        }
        encoder.writeInt((int)days);
        ++this.currentIndex;
    }
}

