/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers;

import org.apache.arrow.adapter.avro.producers.Producer;
import org.apache.arrow.vector.FieldVector;

public abstract class BaseAvroProducer<T extends FieldVector>
implements Producer<T> {
    protected T vector;
    protected int currentIndex;

    protected BaseAvroProducer(T vector) {
        this.vector = vector;
    }

    @Override
    public void skipNull() {
        ++this.currentIndex;
    }

    @Override
    public void setPosition(int index) {
        if (index < 0 || index > this.vector.getValueCount()) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        this.currentIndex = index;
    }

    @Override
    public void resetValueVector(T vector) {
        this.vector = vector;
        this.currentIndex = 0;
    }

    @Override
    public T getVector() {
        return this.vector;
    }
}

