/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers;

import java.io.IOException;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.avro.io.Encoder;

public class AvroUint8Producer
extends BaseAvroProducer<UInt8Vector> {
    public AvroUint8Producer(UInt8Vector vector) {
        super(vector);
    }

    @Override
    public void produce(Encoder encoder) throws IOException {
        long unsigned = ((UInt8Vector)this.vector).getDataBuffer().getLong((long)this.currentIndex * 8L);
        if (unsigned < 0L) {
            throw new ArithmeticException("Unsigned long value is too large for Avro encoding");
        }
        encoder.writeLong(unsigned);
        ++this.currentIndex;
    }
}

