/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers;

import java.io.IOException;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.adapter.avro.producers.Producer;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.avro.io.Encoder;

public class AvroMapProducer
extends BaseAvroProducer<MapVector> {
    private final Producer<? extends FieldVector> delegate;

    public AvroMapProducer(MapVector vector, Producer<? extends FieldVector> delegate) {
        super(vector);
        this.delegate = delegate;
    }

    @Override
    public void produce(Encoder encoder) throws IOException {
        int startOffset = ((MapVector)this.vector).getOffsetBuffer().getInt((long)this.currentIndex * 4L);
        int endOffset = ((MapVector)this.vector).getOffsetBuffer().getInt((long)(this.currentIndex + 1) * 4L);
        int nEntries = endOffset - startOffset;
        encoder.writeMapStart();
        encoder.setItemCount((long)nEntries);
        for (int i = 0; i < nEntries; ++i) {
            encoder.startItem();
            this.delegate.produce(encoder);
        }
        encoder.writeMapEnd();
        ++this.currentIndex;
    }

    @Override
    public void setPosition(int index) {
        if (index < 0 || index > ((MapVector)this.vector).getValueCount()) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        int delegateOffset = ((MapVector)this.vector).getOffsetBuffer().getInt((long)index * 4L);
        this.delegate.setPosition(delegateOffset);
        super.setPosition(index);
    }

    @Override
    public void resetValueVector(MapVector vector) {
        this.delegate.resetValueVector((FieldVector)vector.getDataVector());
    }
}

