/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.producers;

import java.io.IOException;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.adapter.avro.producers.Producer;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.avro.io.Encoder;

public class AvroFixedSizeListProducer
extends BaseAvroProducer<FixedSizeListVector> {
    private final Producer<? extends FieldVector> delegate;

    public AvroFixedSizeListProducer(FixedSizeListVector vector, Producer<? extends FieldVector> delegate) {
        super(vector);
        this.delegate = delegate;
    }

    @Override
    public void produce(Encoder encoder) throws IOException {
        encoder.writeArrayStart();
        encoder.setItemCount((long)((FixedSizeListVector)this.vector).getListSize());
        for (int i = 0; i < ((FixedSizeListVector)this.vector).getListSize(); ++i) {
            encoder.startItem();
            this.delegate.produce(encoder);
        }
        encoder.writeArrayEnd();
        ++this.currentIndex;
    }

    @Override
    public void skipNull() {
        super.skipNull();
        int childIndex = this.currentIndex * ((FixedSizeListVector)this.vector).getListSize();
        this.delegate.setPosition(childIndex);
    }

    @Override
    public void setPosition(int index) {
        if (index < 0 || index > ((FixedSizeListVector)this.vector).getValueCount()) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        super.setPosition(index);
        int childIndex = this.currentIndex * ((FixedSizeListVector)this.vector).getListSize();
        this.delegate.setPosition(childIndex);
    }

    @Override
    public void resetValueVector(FixedSizeListVector vector) {
        this.delegate.resetValueVector((FieldVector)vector.getDataVector());
    }
}

