/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro.consumers.logical;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.arrow.adapter.avro.consumers.BaseAvroConsumer;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.avro.io.Decoder;

public abstract class AvroDecimal256Consumer
extends BaseAvroConsumer<Decimal256Vector> {
    protected AvroDecimal256Consumer(Decimal256Vector vector) {
        super(vector);
    }

    public static class FixedDecimal256Consumer
    extends AvroDecimal256Consumer {
        private final byte[] reuseBytes;

        public FixedDecimal256Consumer(Decimal256Vector vector, int size) {
            super(vector);
            Preconditions.checkArgument((size <= 32 ? 1 : 0) != 0, (Object)"Decimal bytes length should <= 32.");
            this.reuseBytes = new byte[size];
        }

        @Override
        public void consume(Decoder decoder) throws IOException {
            decoder.readFixed(this.reuseBytes);
            ((Decimal256Vector)this.vector).setBigEndian(this.currentIndex++, this.reuseBytes);
        }
    }

    public static class BytesDecimal256Consumer
    extends AvroDecimal256Consumer {
        private ByteBuffer cacheBuffer;

        public BytesDecimal256Consumer(Decimal256Vector vector) {
            super(vector);
        }

        @Override
        public void consume(Decoder decoder) throws IOException {
            this.cacheBuffer = decoder.readBytes(this.cacheBuffer);
            byte[] bytes = new byte[this.cacheBuffer.limit()];
            Preconditions.checkArgument((bytes.length <= 32 ? 1 : 0) != 0, (Object)"Decimal bytes length should <= 32.");
            this.cacheBuffer.get(bytes);
            ((Decimal256Vector)this.vector).setBigEndian(this.currentIndex++, bytes);
        }
    }
}

