/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro;

import java.io.IOException;
import org.apache.arrow.adapter.avro.AvroToArrowConfig;
import org.apache.arrow.adapter.avro.AvroToArrowUtils;
import org.apache.arrow.adapter.avro.AvroToArrowVectorIterator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.avro.io.Decoder;

public class AvroToArrow {
    static VectorSchemaRoot avroToArrow(org.apache.avro.Schema schema, Decoder decoder, AvroToArrowConfig config) throws IOException {
        Preconditions.checkNotNull((Object)schema, (Object)"Avro schema object cannot be null");
        Preconditions.checkNotNull((Object)decoder, (Object)"Avro decoder object cannot be null");
        Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        return AvroToArrowUtils.avroToArrowVectors(schema, decoder, config);
    }

    public static AvroToArrowVectorIterator avroToArrowIterator(org.apache.avro.Schema schema, Decoder decoder, AvroToArrowConfig config) throws IOException {
        Preconditions.checkNotNull((Object)schema, (Object)"Avro schema object cannot be null");
        Preconditions.checkNotNull((Object)decoder, (Object)"Avro decoder object cannot be null");
        Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        return AvroToArrowVectorIterator.create(decoder, schema, config);
    }

    public static Schema avroToAvroSchema(org.apache.avro.Schema schema, AvroToArrowConfig config) {
        Preconditions.checkNotNull((Object)schema, (Object)"Avro schema object cannot be null");
        Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
        return AvroToArrowUtils.createArrowSchema(schema, config);
    }
}

