/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.adapter.avro;

import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.adapter.avro.producers.AvroBigIntProducer;
import org.apache.arrow.adapter.avro.producers.AvroBooleanProducer;
import org.apache.arrow.adapter.avro.producers.AvroBytesProducer;
import org.apache.arrow.adapter.avro.producers.AvroFixedSizeBinaryProducer;
import org.apache.arrow.adapter.avro.producers.AvroFixedSizeListProducer;
import org.apache.arrow.adapter.avro.producers.AvroFloat2Producer;
import org.apache.arrow.adapter.avro.producers.AvroFloat4Producer;
import org.apache.arrow.adapter.avro.producers.AvroFloat8Producer;
import org.apache.arrow.adapter.avro.producers.AvroIntProducer;
import org.apache.arrow.adapter.avro.producers.AvroListProducer;
import org.apache.arrow.adapter.avro.producers.AvroMapProducer;
import org.apache.arrow.adapter.avro.producers.AvroNullProducer;
import org.apache.arrow.adapter.avro.producers.AvroNullableProducer;
import org.apache.arrow.adapter.avro.producers.AvroSmallIntProducer;
import org.apache.arrow.adapter.avro.producers.AvroStringProducer;
import org.apache.arrow.adapter.avro.producers.AvroStructProducer;
import org.apache.arrow.adapter.avro.producers.AvroTinyIntProducer;
import org.apache.arrow.adapter.avro.producers.AvroUint1Producer;
import org.apache.arrow.adapter.avro.producers.AvroUint2Producer;
import org.apache.arrow.adapter.avro.producers.AvroUint4Producer;
import org.apache.arrow.adapter.avro.producers.AvroUint8Producer;
import org.apache.arrow.adapter.avro.producers.BaseAvroProducer;
import org.apache.arrow.adapter.avro.producers.CompositeAvroProducer;
import org.apache.arrow.adapter.avro.producers.Producer;
import org.apache.arrow.adapter.avro.producers.logical.AvroDateDayProducer;
import org.apache.arrow.adapter.avro.producers.logical.AvroDateMilliProducer;
import org.apache.arrow.adapter.avro.producers.logical.AvroDecimal256Producer;
import org.apache.arrow.adapter.avro.producers.logical.AvroDecimalProducer;
import org.apache.arrow.adapter.avro.producers.logical.AvroTimeMicroProducer;
import org.apache.arrow.adapter.avro.producers.logical.AvroTimeMilliProducer;
import org.apache.arrow.adapter.avro.producers.logical.AvroTimeNanoProducer;
import org.apache.arrow.adapter.avro.producers.logical.AvroTimeSecProducer;
import org.apache.arrow.adapter.avro.producers.logical.AvroTimestampMicroProducer;
import org.apache.arrow.adapter.avro.producers.logical.AvroTimestampMicroTzProducer;
import org.apache.arrow.adapter.avro.producers.logical.AvroTimestampMilliProducer;
import org.apache.arrow.adapter.avro.producers.logical.AvroTimestampMilliTzProducer;
import org.apache.arrow.adapter.avro.producers.logical.AvroTimestampNanoProducer;
import org.apache.arrow.adapter.avro.producers.logical.AvroTimestampNanoTzProducer;
import org.apache.arrow.adapter.avro.producers.logical.AvroTimestampSecProducer;
import org.apache.arrow.adapter.avro.producers.logical.AvroTimestampSecTzProducer;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.Decimal256Vector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.FixedSizeBinaryVector;
import org.apache.arrow.vector.Float2Vector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeMicroVector;
import org.apache.arrow.vector.TimeMilliVector;
import org.apache.arrow.vector.TimeNanoVector;
import org.apache.arrow.vector.TimeSecVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TimeStampMilliVector;
import org.apache.arrow.vector.TimeStampNanoTZVector;
import org.apache.arrow.vector.TimeStampNanoVector;
import org.apache.arrow.vector.TimeStampSecTZVector;
import org.apache.arrow.vector.TimeStampSecVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.FixedSizeListVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;

public class ArrowToAvroUtils {
    public static final String GENERIC_RECORD_TYPE_NAME = "GenericRecord";

    public static Schema createAvroSchema(List<Field> arrowFields, String typeName, String namespace) {
        SchemaBuilder.RecordBuilder assembler = (SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)typeName).namespace(namespace);
        return (Schema)ArrowToAvroUtils.buildRecordSchema(assembler, arrowFields, namespace);
    }

    public static Schema createAvroSchema(List<Field> arrowFields, String typeName) {
        return ArrowToAvroUtils.createAvroSchema(arrowFields, typeName, null);
    }

    public static Schema createAvroSchema(List<Field> arrowFields) {
        return ArrowToAvroUtils.createAvroSchema(arrowFields, GENERIC_RECORD_TYPE_NAME);
    }

    private static <T> T buildRecordSchema(SchemaBuilder.RecordBuilder<T> builder, List<Field> fields, String namespace) {
        if (fields.isEmpty()) {
            throw new IllegalArgumentException("Record field must have at least one child field");
        }
        SchemaBuilder.FieldAssembler<T> assembler = ((SchemaBuilder.RecordBuilder)builder.namespace(namespace)).fields();
        for (Field field : fields) {
            assembler = ArrowToAvroUtils.buildFieldSchema(assembler, field, namespace);
        }
        return (T)assembler.endRecord();
    }

    private static <T> SchemaBuilder.FieldAssembler<T> buildFieldSchema(SchemaBuilder.FieldAssembler<T> assembler, Field field, String namespace) {
        return assembler.name(field.getName()).type((Schema)ArrowToAvroUtils.buildTypeSchema(SchemaBuilder.builder(), field, namespace)).noDefault();
    }

    private static <T> T buildTypeSchema(SchemaBuilder.TypeBuilder<T> builder, Field field, String namespace) {
        if (field.getType().getTypeID() == ArrowType.ArrowTypeID.Union) {
            boolean unionNullable = field.getChildren().stream().anyMatch(Field::isNullable);
            if (unionNullable) {
                SchemaBuilder.UnionAccumulator union = (SchemaBuilder.UnionAccumulator)builder.unionOf().nullType();
                return ArrowToAvroUtils.addTypesToUnion(union, field.getChildren(), namespace);
            }
            Field headType = (Field)field.getChildren().get(0);
            List<Field> tailTypes = field.getChildren().subList(1, field.getChildren().size());
            SchemaBuilder.UnionAccumulator union = (SchemaBuilder.UnionAccumulator)ArrowToAvroUtils.buildBaseTypeSchema(builder.unionOf(), headType, namespace);
            return ArrowToAvroUtils.addTypesToUnion(union, tailTypes, namespace);
        }
        if (field.isNullable()) {
            return ArrowToAvroUtils.buildBaseTypeSchema(builder.nullable(), field, namespace);
        }
        return ArrowToAvroUtils.buildBaseTypeSchema(builder, field, namespace);
    }

    private static <T> T buildArraySchema(SchemaBuilder.ArrayBuilder<T> builder, Field listField, String namespace) {
        if (listField.getChildren().size() != 1) {
            throw new IllegalArgumentException("List field must have exactly one child field");
        }
        Field itemField = (Field)listField.getChildren().get(0);
        return ArrowToAvroUtils.buildTypeSchema(builder.items(), itemField, namespace);
    }

    private static <T> T buildMapSchema(SchemaBuilder.MapBuilder<T> builder, Field mapField, String namespace) {
        if (mapField.getChildren().size() != 1) {
            throw new IllegalArgumentException("Map field must have exactly one child field");
        }
        Field entriesField = (Field)mapField.getChildren().get(0);
        if (mapField.getChildren().size() != 1) {
            throw new IllegalArgumentException("Map entries must have exactly two child fields");
        }
        Field keyField = (Field)entriesField.getChildren().get(0);
        Field valueField = (Field)entriesField.getChildren().get(1);
        if (keyField.getType().getTypeID() != ArrowType.ArrowTypeID.Utf8 || keyField.isNullable()) {
            throw new IllegalArgumentException("Map keys must be of type string and cannot be nullable for conversion to Avro");
        }
        return ArrowToAvroUtils.buildTypeSchema(builder.values(), valueField, namespace);
    }

    private static <T> T buildBaseTypeSchema(SchemaBuilder.BaseTypeBuilder<T> builder, Field field, String namespace) {
        ArrowType.ArrowTypeID typeID = field.getType().getTypeID();
        switch (typeID) {
            case Null: {
                return (T)builder.nullType();
            }
            case Bool: {
                return (T)builder.booleanType();
            }
            case Int: {
                ArrowType.Int intType = (ArrowType.Int)field.getType();
                if (intType.getBitWidth() > 32 || intType.getBitWidth() == 32 && !intType.getIsSigned()) {
                    return (T)builder.longType();
                }
                return (T)builder.intType();
            }
            case FloatingPoint: {
                ArrowType.FloatingPoint floatType = (ArrowType.FloatingPoint)field.getType();
                if (floatType.getPrecision() == FloatingPointPrecision.DOUBLE) {
                    return (T)builder.doubleType();
                }
                return (T)builder.floatType();
            }
            case Utf8: {
                return (T)builder.stringType();
            }
            case Binary: {
                return (T)builder.bytesType();
            }
            case FixedSizeBinary: {
                ArrowType.FixedSizeBinary fixedType = (ArrowType.FixedSizeBinary)field.getType();
                String fixedTypeName = field.getName();
                int fixedTypeWidth = fixedType.getByteWidth();
                return (T)builder.fixed(fixedTypeName).size(fixedTypeWidth);
            }
            case Decimal: {
                ArrowType.Decimal decimalType = (ArrowType.Decimal)field.getType();
                return (T)builder.type(LogicalTypes.decimal((int)decimalType.getPrecision(), (int)decimalType.getScale()).addToSchema(Schema.createFixed((String)field.getName(), (String)namespace, (String)"", (int)(decimalType.getBitWidth() / 8))));
            }
            case Date: {
                return (T)builder.type(LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT)));
            }
            case Time: {
                ArrowType.Time timeType = (ArrowType.Time)field.getType();
                if (timeType.getUnit() == TimeUnit.SECOND || timeType.getUnit() == TimeUnit.MILLISECOND) {
                    return (T)builder.type(LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT)));
                }
                return (T)builder.type(LogicalTypes.timeMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)));
            }
            case Timestamp: {
                ArrowType.Timestamp timestampType = (ArrowType.Timestamp)field.getType();
                LogicalType timestampLogicalType = ArrowToAvroUtils.timestampLogicalType(timestampType);
                return (T)builder.type(timestampLogicalType.addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)));
            }
            case Struct: {
                String childNamespace = namespace == null ? field.getName() : namespace + "." + field.getName();
                return ArrowToAvroUtils.buildRecordSchema(builder.record(field.getName()), field.getChildren(), childNamespace);
            }
            case List: 
            case FixedSizeList: {
                Field itemField = (Field)field.getChildren().get(0);
                if ("$data$".equals(itemField.getName())) {
                    Field safeItemField = new Field("item", itemField.getFieldType(), itemField.getChildren());
                    Field safeListField = new Field(field.getName(), field.getFieldType(), List.of(safeItemField));
                    return ArrowToAvroUtils.buildArraySchema(builder.array(), safeListField, namespace);
                }
                return ArrowToAvroUtils.buildArraySchema(builder.array(), field, namespace);
            }
            case Map: {
                return ArrowToAvroUtils.buildMapSchema(builder.map(), field, namespace);
            }
        }
        throw new IllegalArgumentException("Element type not supported for Avro conversion: " + typeID.name());
    }

    private static <T> T addTypesToUnion(SchemaBuilder.UnionAccumulator<T> accumulator, List<Field> unionFields, String namespace) {
        for (Field field : unionFields) {
            accumulator = (SchemaBuilder.UnionAccumulator)ArrowToAvroUtils.buildBaseTypeSchema(accumulator.and(), field, namespace);
        }
        return (T)accumulator.endUnion();
    }

    private static LogicalType timestampLogicalType(ArrowType.Timestamp timestampType) {
        boolean zoneAware;
        boolean bl = zoneAware = timestampType.getTimezone() != null;
        if (timestampType.getUnit() == TimeUnit.NANOSECOND) {
            return zoneAware ? LogicalTypes.timestampNanos() : LogicalTypes.localTimestampNanos();
        }
        if (timestampType.getUnit() == TimeUnit.MICROSECOND) {
            return zoneAware ? LogicalTypes.timestampMicros() : LogicalTypes.localTimestampMicros();
        }
        return zoneAware ? LogicalTypes.timestampMillis() : LogicalTypes.localTimestampMillis();
    }

    public static CompositeAvroProducer createCompositeProducer(List<FieldVector> vectors) {
        ArrayList<Producer<? extends FieldVector>> producers = new ArrayList<Producer<? extends FieldVector>>(vectors.size());
        for (FieldVector vector : vectors) {
            BaseAvroProducer<?> producer = ArrowToAvroUtils.createProducer(vector);
            producers.add(producer);
        }
        return new CompositeAvroProducer(producers);
    }

    private static BaseAvroProducer<?> createProducer(FieldVector vector) {
        boolean nullable = vector.getField().isNullable();
        return ArrowToAvroUtils.createProducer(vector, nullable);
    }

    private static BaseAvroProducer<?> createProducer(FieldVector vector, boolean nullable) {
        Preconditions.checkNotNull((Object)vector, (Object)"Arrow vector object can't be null");
        Types.MinorType minorType = vector.getMinorType();
        if (nullable && minorType != Types.MinorType.UNION) {
            BaseAvroProducer<?> innerProducer = ArrowToAvroUtils.createProducer(vector, false);
            return new AvroNullableProducer((Producer<?>)innerProducer);
        }
        switch (minorType) {
            case NULL: {
                return new AvroNullProducer((NullVector)vector);
            }
            case BIT: {
                return new AvroBooleanProducer((BitVector)vector);
            }
            case TINYINT: {
                return new AvroTinyIntProducer((TinyIntVector)vector);
            }
            case SMALLINT: {
                return new AvroSmallIntProducer((SmallIntVector)vector);
            }
            case INT: {
                return new AvroIntProducer((IntVector)vector);
            }
            case BIGINT: {
                return new AvroBigIntProducer((BigIntVector)vector);
            }
            case UINT1: {
                return new AvroUint1Producer((UInt1Vector)vector);
            }
            case UINT2: {
                return new AvroUint2Producer((UInt2Vector)vector);
            }
            case UINT4: {
                return new AvroUint4Producer((UInt4Vector)vector);
            }
            case UINT8: {
                return new AvroUint8Producer((UInt8Vector)vector);
            }
            case FLOAT2: {
                return new AvroFloat2Producer((Float2Vector)vector);
            }
            case FLOAT4: {
                return new AvroFloat4Producer((Float4Vector)vector);
            }
            case FLOAT8: {
                return new AvroFloat8Producer((Float8Vector)vector);
            }
            case VARBINARY: {
                return new AvroBytesProducer((VarBinaryVector)vector);
            }
            case FIXEDSIZEBINARY: {
                return new AvroFixedSizeBinaryProducer((FixedSizeBinaryVector)vector);
            }
            case VARCHAR: {
                return new AvroStringProducer((VarCharVector)vector);
            }
            case DECIMAL: {
                return new AvroDecimalProducer((DecimalVector)vector);
            }
            case DECIMAL256: {
                return new AvroDecimal256Producer((Decimal256Vector)vector);
            }
            case DATEDAY: {
                return new AvroDateDayProducer((DateDayVector)vector);
            }
            case DATEMILLI: {
                return new AvroDateMilliProducer((DateMilliVector)vector);
            }
            case TIMESEC: {
                return new AvroTimeSecProducer((TimeSecVector)vector);
            }
            case TIMEMILLI: {
                return new AvroTimeMilliProducer((TimeMilliVector)vector);
            }
            case TIMEMICRO: {
                return new AvroTimeMicroProducer((TimeMicroVector)vector);
            }
            case TIMENANO: {
                return new AvroTimeNanoProducer((TimeNanoVector)vector);
            }
            case TIMESTAMPSEC: {
                return new AvroTimestampSecProducer((TimeStampSecVector)vector);
            }
            case TIMESTAMPMILLI: {
                return new AvroTimestampMilliProducer((TimeStampMilliVector)vector);
            }
            case TIMESTAMPMICRO: {
                return new AvroTimestampMicroProducer((TimeStampMicroVector)vector);
            }
            case TIMESTAMPNANO: {
                return new AvroTimestampNanoProducer((TimeStampNanoVector)vector);
            }
            case TIMESTAMPSECTZ: {
                return new AvroTimestampSecTzProducer((TimeStampSecTZVector)vector);
            }
            case TIMESTAMPMILLITZ: {
                return new AvroTimestampMilliTzProducer((TimeStampMilliTZVector)vector);
            }
            case TIMESTAMPMICROTZ: {
                return new AvroTimestampMicroTzProducer((TimeStampMicroTZVector)vector);
            }
            case TIMESTAMPNANOTZ: {
                return new AvroTimestampNanoTzProducer((TimeStampNanoTZVector)vector);
            }
            case STRUCT: {
                StructVector structVector = (StructVector)vector;
                List childVectors = structVector.getChildrenFromFields();
                Producer[] childProducers = new Producer[childVectors.size()];
                for (int i = 0; i < childVectors.size(); ++i) {
                    FieldVector childVector = (FieldVector)childVectors.get(i);
                    childProducers[i] = ArrowToAvroUtils.createProducer(childVector, childVector.getField().isNullable());
                }
                return new AvroStructProducer(structVector, childProducers);
            }
            case LIST: {
                ListVector listVector = (ListVector)vector;
                FieldVector itemVector = listVector.getDataVector();
                BaseAvroProducer<?> itemProducer = ArrowToAvroUtils.createProducer(itemVector, itemVector.getField().isNullable());
                return new AvroListProducer(listVector, itemProducer);
            }
            case FIXED_SIZE_LIST: {
                FixedSizeListVector fixedListVector = (FixedSizeListVector)vector;
                FieldVector fixedItemVector = fixedListVector.getDataVector();
                BaseAvroProducer<?> fixedItemProducer = ArrowToAvroUtils.createProducer(fixedItemVector, fixedItemVector.getField().isNullable());
                return new AvroFixedSizeListProducer(fixedListVector, fixedItemProducer);
            }
            case MAP: {
                MapVector mapVector = (MapVector)vector;
                StructVector entryVector = (StructVector)mapVector.getDataVector();
                Types.MinorType keyType = ((FieldVector)entryVector.getChildrenFromFields().get(0)).getMinorType();
                if (keyType != Types.MinorType.VARCHAR) {
                    throw new IllegalArgumentException("MAP key type must be VARCHAR for Avro encoding");
                }
                VarCharVector keyVector = (VarCharVector)entryVector.getChildrenFromFields().get(0);
                FieldVector valueVector = (FieldVector)entryVector.getChildrenFromFields().get(1);
                AvroStringProducer keyProducer = new AvroStringProducer(keyVector);
                BaseAvroProducer<?> valueProducer = ArrowToAvroUtils.createProducer(valueVector, valueVector.getField().isNullable());
                AvroStructProducer entryProducer = new AvroStructProducer(entryVector, new Producer[]{keyProducer, valueProducer});
                return new AvroMapProducer(mapVector, entryProducer);
            }
        }
        String error = String.format("Encoding Arrow type %s to Avro is not currently supported", minorType.name());
        throw new UnsupportedOperationException(error);
    }
}

