/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow;

import java.util.Set;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.dictionary.DictionaryProvider;

public class AvroToArrowConfig {
    private final BufferAllocator allocator;
    private final int targetBatchSize;
    private final DictionaryProvider.MapDictionaryProvider provider;
    private final Set<String> skipFieldNames;

    AvroToArrowConfig(BufferAllocator allocator, int targetBatchSize, DictionaryProvider.MapDictionaryProvider provider, Set<String> skipFieldNames) {
        Preconditions.checkArgument((targetBatchSize == -1 || targetBatchSize > 0 ? 1 : 0) != 0, (String)"invalid targetBatchSize: %s", (int)targetBatchSize);
        this.allocator = allocator;
        this.targetBatchSize = targetBatchSize;
        this.provider = provider;
        this.skipFieldNames = skipFieldNames;
    }

    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    public int getTargetBatchSize() {
        return this.targetBatchSize;
    }

    public DictionaryProvider.MapDictionaryProvider getProvider() {
        return this.provider;
    }

    public Set<String> getSkipFieldNames() {
        return this.skipFieldNames;
    }
}

