/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers;

import java.io.IOException;
import java.util.List;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.avro.io.Decoder;

public class CompositeAvroConsumer
implements AutoCloseable {
    private final List<Consumer> consumers;

    public List<Consumer> getConsumers() {
        return this.consumers;
    }

    public CompositeAvroConsumer(List<Consumer> consumers) {
        this.consumers = consumers;
    }

    public void consume(Decoder decoder, VectorSchemaRoot root) throws IOException {
        for (Consumer consumer : this.consumers) {
            consumer.consume(decoder);
        }
    }

    public void resetConsumerVectors(VectorSchemaRoot root) {
        for (int i = 0; i < root.getFieldVectors().size(); ++i) {
            this.consumers.get(i).resetValueVector((ValueVector)root.getFieldVectors().get(i));
        }
    }

    @Override
    public void close() {
        try {
            AutoCloseables.close(this.consumers);
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurs in close.", e);
        }
    }
}

