/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers;

import java.io.IOException;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.avro.io.Decoder;

public class AvroMapConsumer
implements Consumer<MapVector> {
    private MapVector vector;
    private final Consumer delegate;
    private int currentIndex;

    public AvroMapConsumer(MapVector vector, Consumer delegate) {
        this.vector = vector;
        this.delegate = delegate;
    }

    @Override
    public void consume(Decoder decoder) throws IOException {
        this.vector.startNewValue(this.currentIndex);
        long totalCount = 0L;
        long count = decoder.readMapStart();
        while (count != 0L) {
            totalCount += count;
            int element = 0;
            while ((long)element < count) {
                this.delegate.consume(decoder);
                ++element;
            }
            count = decoder.mapNext();
        }
        this.vector.endValue(this.currentIndex, (int)totalCount);
        ++this.currentIndex;
    }

    @Override
    public void addNull() {
        this.vector.setValueCount(this.vector.getValueCount() + 1);
    }

    @Override
    public void setPosition(int index) {
        this.currentIndex = index;
    }

    @Override
    public FieldVector getVector() {
        return this.vector;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
        this.delegate.close();
    }

    @Override
    public void resetValueVector(MapVector vector) {
        this.vector = vector;
        this.delegate.resetValueVector(vector.getDataVector());
        this.currentIndex = 0;
    }
}

