/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.consumers;

import java.io.IOException;
import org.apache.arrow.consumers.Consumer;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.avro.io.Decoder;

public class AvroBooleanConsumer
implements Consumer<BitVector> {
    private BitVector vector;
    private int currentIndex = 0;

    public AvroBooleanConsumer(BitVector vector) {
        this.vector = vector;
    }

    @Override
    public void consume(Decoder decoder) throws IOException {
        this.vector.setSafe(this.currentIndex, decoder.readBoolean() ? 1 : 0);
        ++this.currentIndex;
    }

    @Override
    public void addNull() {
        ++this.currentIndex;
    }

    @Override
    public void setPosition(int index) {
        this.currentIndex = index;
    }

    @Override
    public FieldVector getVector() {
        return this.vector;
    }

    @Override
    public void close() throws Exception {
        this.vector.close();
    }

    @Override
    public void resetValueVector(BitVector vector) {
        this.vector = vector;
        this.currentIndex = 0;
    }
}

